/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitEnricher;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.dmz.commit.DmzCommitEnricher;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.CommitPropertyConfiguration;
import com.atlassian.bitbucket.idx.CommitPropertyConfigurationModuleDescriptor;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitEnricher;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.comment.InternalCommentService;
import com.atlassian.stash.internal.pull.InternalPullRequestCommitEnricher;
import com.atlassian.stash.internal.user.InternalUserService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={CommitEnricher.class, PullRequestCommitEnricher.class})
@Component(value="commitEnricher")
@Profiled
@Transactional(readOnly=true)
public class PluggableCommitEnricher
implements DmzCommitEnricher,
InternalPullRequestCommitEnricher {
    private final AuthenticationContext authenticationContext;
    private final InternalCommentService commentService;
    private final CommitIndex index;
    private final PluginAccessor pluginAccessor;
    private final InternalUserService userService;

    @Autowired
    public PluggableCommitEnricher(AuthenticationContext authenticationContext, InternalCommentService commentService, CommitIndex index, PluginAccessor pluginAccessor, InternalUserService userService) {
        this.authenticationContext = authenticationContext;
        this.commentService = commentService;
        this.index = index;
        this.pluginAccessor = pluginAccessor;
        this.userService = userService;
    }

    @Nonnull
    public Commit enrich(@Nonnull PullRequest pullRequest, @Nonnull Commit commit, Collection<String> propertyKeys) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(commit, "commit");
        return this.createEnricher(pullRequest, Collections.singleton(commit), propertyKeys).apply(commit);
    }

    @Nonnull
    public Commit enrich(@Nonnull Repository repository, @Nonnull Commit commit, Collection<String> propertyKeys) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commit, "commit");
        return this.createEnricher(repository, Collections.singleton(commit), propertyKeys).apply(commit);
    }

    @Override
    @Nonnull
    public Iterable<Commit> enrichAll(@Nonnull PullRequest pullRequest, @Nonnull Iterable<Commit> commits, Collection<String> propertyKeys) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(commits, "commits");
        return (Iterable)MoreStreams.streamIterable(commits).map(this.createEnricher(pullRequest, commits, propertyKeys)).collect(MoreCollectors.toImmutableList());
    }

    @Nonnull
    public Iterable<Commit> enrichAll(@Nonnull Repository repository, @Nonnull Iterable<Commit> commits, Collection<String> propertyKeys) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commits, "commits");
        return (Iterable)MoreStreams.streamIterable(commits).map(this.createEnricher(repository, commits, propertyKeys)).collect(MoreCollectors.toImmutableList());
    }

    @Nonnull
    public Page<Commit> enrichPage(@Nonnull PullRequest pullRequest, @Nonnull Page<Commit> page, Collection<String> propertyKeys) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(page, "page");
        return page.transform(this.createEnricher(pullRequest, (Iterable<Commit>)page.getValues(), propertyKeys));
    }

    @Nonnull
    public Page<Commit> enrichPage(@Nonnull Repository repository, @Nonnull Page<Commit> page, Collection<String> propertyKeys) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(page, "page");
        return page.transform(this.createEnricher(repository, (Iterable<Commit>)page.getValues(), propertyKeys));
    }

    private static Function<Commit, Commit> createEnricher(Map<String, Map<String, Object>> propertiesByCommit, Map<String, ApplicationUser> usersByEmail, Map<String, Long> commentsByCommit) {
        if (propertiesByCommit.isEmpty() && usersByEmail.isEmpty() && commentsByCommit.isEmpty()) {
            return Function.identity();
        }
        return commit -> {
            Long comments;
            Map commitProperties;
            ApplicationUser committer;
            SimpleCommit.Builder builder = null;
            ApplicationUser author = (ApplicationUser)usersByEmail.get(commit.getAuthor().getEmailAddress());
            if (author != null) {
                builder = new SimpleCommit.Builder(commit).author((Person)author);
            }
            if ((committer = (ApplicationUser)usersByEmail.get(commit.getCommitter().getEmailAddress())) != null) {
                if (builder == null) {
                    builder = new SimpleCommit.Builder(commit);
                }
                builder.committer((Person)committer);
            }
            if ((commitProperties = (Map)propertiesByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new SimpleCommit.Builder(commit);
                }
                builder.properties(commitProperties);
            }
            if ((comments = (Long)commentsByCommit.get(commit.getId())) != null) {
                if (builder == null) {
                    builder = new SimpleCommit.Builder(commit);
                }
                builder.property("commentCount", (Object)comments);
            }
            return builder == null ? commit : builder.build();
        };
    }

    private Function<Commit, Commit> createEnricher(PullRequest pullRequest, Iterable<Commit> commits, Collection<String> propertyKeys) {
        Set commitIds = (Set)MoreStreams.streamIterable(commits).map(MinimalCommit::getId).collect(MoreCollectors.toImmutableSet());
        return PluggableCommitEnricher.createEnricher(this.mapPropertiesByCommit(pullRequest.getToRef().getRepository(), commitIds, propertyKeys), this.mapContributorsByEmail(commits), this.mapCommentsByCommit(pullRequest, (Set<String>)commitIds));
    }

    private Function<Commit, Commit> createEnricher(Repository repository, Iterable<Commit> commits, Collection<String> propertyKeys) {
        Set commitIds = (Set)MoreStreams.streamIterable(commits).map(MinimalCommit::getId).collect(MoreCollectors.toImmutableSet());
        return PluggableCommitEnricher.createEnricher(this.mapPropertiesByCommit(repository, commitIds, propertyKeys), this.mapContributorsByEmail(commits), this.mapCommentsByCommit(repository, (Set<String>)commitIds));
    }

    private Map<CommitPropertyConfiguration, Collection<String>> getAllConfigPropertyKeysToPreload(Repository repository) {
        List<CommitPropertyConfiguration> commitPropertyConfigurations = this.getModules(CommitPropertyConfigurationModuleDescriptor.class).collect(Collectors.toList());
        LinkedHashMap<CommitPropertyConfiguration, Collection<String>> commitPropertyConfigurationToProperties = new LinkedHashMap<CommitPropertyConfiguration, Collection<String>>();
        commitPropertyConfigurations.forEach(configuration -> {
            Collection commitPropertiesToPreload = configuration.getPropertiesToPreload(repository);
            commitPropertyConfigurationToProperties.put((CommitPropertyConfiguration)configuration, commitPropertiesToPreload);
        });
        return commitPropertyConfigurationToProperties;
    }

    private <M, MD extends BaseWeightedModuleDescriptor<M>> Stream<M> getModules(Class<MD> descriptorClass) {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(descriptorClass));
    }

    private Map<String, Long> mapCommentsByCommit(Repository repository, Set<String> commitIds) {
        if (this.authenticationContext.isAuthenticated()) {
            return this.commentService.countCommentsByCommit(InternalConverter.convertToInternalRepository((Repository)repository), commitIds);
        }
        return Collections.emptyMap();
    }

    private Map<String, Long> mapCommentsByCommit(PullRequest pullRequest, Set<String> commitIds) {
        if (this.authenticationContext.isAuthenticated()) {
            return this.commentService.countCommentsByCommit(InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest), commitIds);
        }
        return Collections.emptyMap();
    }

    private Map<String, ApplicationUser> mapContributorsByEmail(Iterable<Commit> commits) {
        return this.userService.mapUsersByEmail((Set)MoreStreams.streamIterable(commits).flatMap(commit -> Stream.of(commit.getAuthor(), commit.getCommitter())).map(Person::getEmailAddress).filter(StringUtils::isNotBlank).collect(MoreCollectors.toImmutableSet()));
    }

    private Map<String, Map<String, Object>> mapPropertiesByCommit(Repository repository, Set<String> commitIds, Collection<String> propertyKeys) {
        Map<CommitPropertyConfiguration, Collection<String>> commitPropertyConfigurationToPropertyKeys = this.getAllConfigPropertyKeysToPreload(repository);
        Set<String> allPropertyKeys = PluggableCommitEnricher.getAllPropertyKeys(propertyKeys, commitPropertyConfigurationToPropertyKeys);
        Map commitIndexProperties = this.index.getProperties(commitIds, allPropertyKeys);
        if (commitIndexProperties.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Map<String, Object>> mutableCommitIndexProperties = commitIndexProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, commitIdEntry -> new HashMap((Map)commitIdEntry.getValue())));
        PluggableCommitEnricher.mergeCommitProperties(mutableCommitIndexProperties, commitPropertyConfigurationToPropertyKeys);
        return mutableCommitIndexProperties;
    }

    private static Set<String> getAllPropertyKeys(Collection<String> propertyKeys, Map<CommitPropertyConfiguration, Collection<String>> commitPropertyConfigurationToProperties) {
        ImmutableSet.Builder allPropertyKeysBuilder = new ImmutableSet.Builder();
        if (!commitPropertyConfigurationToProperties.isEmpty()) {
            commitPropertyConfigurationToProperties.forEach((configuration, properties) -> allPropertyKeysBuilder.addAll((Iterable)properties));
        }
        if (propertyKeys != null && !propertyKeys.isEmpty()) {
            allPropertyKeysBuilder.addAll(propertyKeys);
        }
        return allPropertyKeysBuilder.build();
    }

    private static Map<String, Object> getPropertyValue(Map.Entry<String, Map<String, Object>> mutableCommitIndexProperty, Collection<String> propertiesToProcess) {
        ImmutableMap.Builder properties = new ImmutableMap.Builder();
        propertiesToProcess.forEach(property -> {
            Object propertyValue = ((Map)mutableCommitIndexProperty.getValue()).get(property);
            if (propertyValue != null) {
                properties.put(property, propertyValue);
            }
        });
        return properties.build();
    }

    private static void mergeCommitProperties(Map<String, Map<String, Object>> mutableCommitIndexProperties, Map<CommitPropertyConfiguration, Collection<String>> commitPropertyConfigurationToPropertyKeys) {
        for (Map.Entry<CommitPropertyConfiguration, Collection<String>> commitConfigurationToPropertyKeys : commitPropertyConfigurationToPropertyKeys.entrySet()) {
            CommitPropertyConfiguration config = commitConfigurationToPropertyKeys.getKey();
            Collection<String> propertyKeys = commitConfigurationToPropertyKeys.getValue();
            Map<String, Map> filteredCommitToPropertiesForConfig = mutableCommitIndexProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, mutableCommitIndexProperty -> PluggableCommitEnricher.getPropertyValue(mutableCommitIndexProperty, propertyKeys)));
            Map processedCommitIdToProperties = config.processProperties(filteredCommitToPropertiesForConfig);
            PluggableCommitEnricher.mergeCommitPropertyMaps(mutableCommitIndexProperties, processedCommitIdToProperties, new HashSet<String>(propertyKeys));
        }
    }

    private static Map<String, Map<String, Object>> mergeCommitPropertyMaps(Map<String, Map<String, Object>> commitPropertiesA, Map<String, Map<String, Object>> commitPropertiesB) {
        return PluggableCommitEnricher.mergeCommitPropertyMaps(commitPropertiesA, commitPropertiesB, Collections.emptySet());
    }

    private static Map<String, Map<String, Object>> mergeCommitPropertyMaps(Map<String, Map<String, Object>> commitPropertiesA, Map<String, Map<String, Object>> commitPropertiesB, Set<String> requestedProperties) {
        commitPropertiesB.forEach((commitId, processedProperties) -> {
            if (commitPropertiesA.containsKey(commitId)) {
                Map commitProperties = (Map)commitPropertiesA.get(commitId);
                requestedProperties.forEach(commitProperties::remove);
                ((Map)commitPropertiesA.get(commitId)).putAll(processedProperties);
            } else {
                commitPropertiesA.put((String)commitId, (Map<String, Object>)processedProperties);
            }
        });
        return commitPropertiesA;
    }
}

