/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.commit.graph.CommitGraphContext;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.commit.graph.SubgraphTraversalCallback;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.commit.graph.TraversalContext;
import com.atlassian.bitbucket.commit.graph.TraversalRequest;
import com.atlassian.bitbucket.commit.graph.TraversalStatus;
import com.atlassian.bitbucket.commit.graph.TraversalSummary;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.commit.graph.CommitGraphSource;
import com.atlassian.stash.internal.commit.graph.cache.AbstractCacheTraversalJob;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphOutputStream;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphUtils;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.atlassian.util.contentcache.BackgroundThreadStreamPumper;
import com.atlassian.util.contentcache.CacheAccess;
import com.atlassian.util.contentcache.CacheResult;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentCacheManager;
import com.atlassian.util.contentcache.ContentProvider;
import com.atlassian.util.contentcache.FileContentCacheManager;
import com.atlassian.util.contentcache.StreamPumper;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class CachingCommitGraphSource
extends AbstractSmartLifecycle
implements CommitGraphSource {
    private static final Logger log = LoggerFactory.getLogger(CachingCommitGraphSource.class);
    private static final String CACHE_KEY = "commit-graph";
    private static final int MAX_RETRIES = 5;
    private static final String NOTIFICATION_TOPIC = "atl.bbs.commitGraph.invalidations";
    private static final String PUMPER_KEY = "commit-graph-pumper";
    private final ContentCache contentCache;
    private final ContentCacheManager contentCacheManager;
    private final StreamPumper contentCachePump = new BackgroundThreadStreamPumper("commit-graph-pumper");
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final Topic<Integer> invalidationTopic;
    private final long maxTraverseWaitTime;
    private final ApplicationMode mode;
    private final RepositorySupplier repositorySupplier;
    private final ScmService scmService;
    private final SecurityService securityService;

    public CachingCommitGraphSource(ExecutorService executorService, HomeLayout homeLayout, I18nService i18nService, long maxTraverseWaitTime, @Value(value="#{applicationPropertiesService.mode}") ApplicationMode mode, RepositorySupplier repositorySupplier, long requiredFreeSpace, ScmService scmService, SecurityService securityService, TopicService topicService) {
        this.contentCacheManager = new FileContentCacheManager.Builder(homeLayout.getCacheDir()).minFreeSpaceBytes(requiredFreeSpace).streamPumper(this.contentCachePump).build();
        this.contentCache = this.createFileCache();
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.maxTraverseWaitTime = maxTraverseWaitTime;
        this.mode = mode;
        this.repositorySupplier = repositorySupplier;
        this.scmService = scmService;
        this.securityService = securityService;
        this.invalidationTopic = topicService.getTopic(NOTIFICATION_TOPIC, new TopicSettings.Builder(Integer.class).dedupePendingMessages(true).build());
    }

    public int getPhase() {
        return 1002;
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (event.getAddedNode().isFullyStarted()) {
            this.contentCache.clear();
        }
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        if (!this.isRunning() || this.isMirrorMode()) {
            return;
        }
        Repository repository = event.getRepository();
        boolean hasRefChanges = event.getRefChanges().stream().map(RefChange::getType).anyMatch(type -> !type.equals((Object)RefChangeType.DELETE));
        log.debug("[{}]: Checking RepositoryRefsChangedEvent; has adds/updates: {}, is fork: {}", new Object[]{repository, hasRefChanges, repository.isFork()});
        if (hasRefChanges) {
            this.invalidationTopic.publish((Serializable)Integer.valueOf(repository.getId()));
            this.invalidateLocalCache(repository);
        }
    }

    public void start() {
        super.start();
        if (this.isMirrorMode()) {
            return;
        }
        this.invalidationTopic.subscribe(message -> {
            Repository repository;
            if (!message.getSource().isLocal() && (repository = (Repository)this.securityService.withPermission(Permission.ADMIN, "Looking up repository to invalidate its commit graph cache").call(() -> this.repositorySupplier.getById(((Integer)message.getMessage()).intValue()))) != null) {
                this.invalidateLocalCache(repository);
            }
        });
    }

    public void stop() {
        this.contentCache.clear();
        this.contentCachePump.shutdown();
        ExecutorUtils.shutdown((ExecutorService)this.executorService, (Logger)log);
        super.stop();
    }

    @Override
    public void traverse(@Nonnull TraversalRequest request, @Nonnull TraversalCallback callback) {
        block19: {
            Objects.requireNonNull(request, "request");
            Objects.requireNonNull(callback, "callback");
            if (!this.isRunning() || this.isMirrorMode()) {
                return;
            }
            Repository repository = request.getRepository();
            CommitGraphContext commitGraphContext = new CommitGraphContext.Builder().exclude((Iterable)request.getExcludes()).include((Iterable)request.getIncludes()).build();
            DelegatingCompletionWaitingTraversalCallback futureCallback = new DelegatingCompletionWaitingTraversalCallback((TraversalCallback)new SubgraphTraversalCallback(callback, commitGraphContext));
            String cacheKey = CachingCommitGraphSource.getCacheKey(repository);
            ContentProvider contentProvider = CachedCommitGraphUtils.getTimedScmContentProvider(repository, this.scmService, this.i18nService);
            try (Timer ignored = TimerUtils.start((String)(repository.getId() + ": reading traversal index"));
                 CachedCommitGraphOutputStream outputStream = new CachedCommitGraphOutputStream(futureCallback);){
                CacheAccess cacheAccess = this.contentCache.access(cacheKey, (OutputStream)outputStream, contentProvider);
                CacheResult cacheResult = cacheAccess.getResult();
                if (cacheResult == CacheResult.MISS) {
                    log.debug("{} during traversal for {}, delegating job to executorService", (Object)cacheResult, (Object)repository);
                    SingleCacheTraversalJob job = new SingleCacheTraversalJob(repository, outputStream, cacheAccess);
                    this.executorService.execute(job);
                    try {
                        futureCallback.await(this.maxTraverseWaitTime, TimeUnit.SECONDS);
                        break block19;
                    }
                    catch (InterruptedException e) {
                        throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.commit.graph.traversal.read.interruptedexception", new Object[]{repository}), (Throwable)e);
                    }
                }
                log.debug("{} during traversal for {}", (Object)cacheResult, (Object)repository);
                try {
                    cacheAccess.stream();
                }
                catch (CachedCommitGraphOutputStream.CachedCommitGraphOutputStreamIOException cachedCommitGraphOutputStreamIOException) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.commit.graph.traversal.read.ioexception", new Object[]{repository}), (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    protected ContentCache createFileCache() {
        return this.contentCacheManager.getCache(CACHE_KEY);
    }

    private static String getCacheKey(int repositoryId) {
        return Integer.toString(repositoryId);
    }

    private static String getCacheKey(Repository repository) {
        return CachingCommitGraphSource.getCacheKey(repository.getId());
    }

    private void invalidateLocalCache(Repository repository) {
        if (repository.isFork()) {
            log.trace("{} invalidating commit-graph cache", (Object)repository);
            this.contentCache.remove(CachingCommitGraphSource.getCacheKey(repository));
        } else {
            log.trace("{} invalidating and priming commit-graph cache", (Object)repository);
            this.executorService.execute(new RetryingCacheTraversalJob(repository, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM));
        }
    }

    private boolean isMirrorMode() {
        return this.mode == ApplicationMode.MIRROR;
    }

    private static class DelegatingCompletionWaitingTraversalCallback
    extends TraversalCallback {
        private final TraversalCallback delegate;
        private final CountDownLatch countDownLatch;
        private volatile boolean finished;

        private DelegatingCompletionWaitingTraversalCallback(TraversalCallback delegate) {
            this.delegate = delegate;
            this.countDownLatch = new CountDownLatch(1);
            this.finished = false;
        }

        public void await(long timeout, TimeUnit unit) throws InterruptedException {
            this.countDownLatch.await(timeout, unit);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void onEnd(@Nonnull TraversalSummary summary) {
            this.delegate.onEnd(summary);
            this.finished = true;
            this.countDownLatch.countDown();
        }

        public TraversalStatus onNode(@Nonnull CommitGraphNode node) {
            return this.delegate.onNode(node);
        }

        public void onStart(@Nonnull TraversalContext context) {
            this.delegate.onStart(context);
        }
    }

    private class SingleCacheTraversalJob
    extends AbstractCacheTraversalJob {
        private static final int PRIORITY = 2;
        private final CacheAccess cacheAccess;

        private SingleCacheTraversalJob(Repository repository, OutputStream outputStream, CacheAccess cacheAccess) {
            super(2, repository, outputStream);
            this.cacheAccess = cacheAccess;
        }

        @Override
        public void run() {
            try {
                this.cacheAccess.stream();
            }
            catch (CachedCommitGraphOutputStream.CachedCommitGraphOutputStreamIOException cachedCommitGraphOutputStreamIOException) {
            }
            catch (IOException e) {
                throw new ServerException(CachingCommitGraphSource.this.i18nService.createKeyedMessage("bitbucket.commit.graph.traversal.read.ioexception", new Object[]{this.repository}), (Throwable)e);
            }
        }
    }

    private class RetryingCacheTraversalJob
    extends AbstractCacheTraversalJob {
        private static final int PRIORITY = 1;
        private final OutputStream outputStream;
        private final int maxRetries;
        private int retries;

        private RetryingCacheTraversalJob(Repository repository, OutputStream outputStream) {
            super(1, repository, outputStream);
            this.outputStream = outputStream;
            this.maxRetries = 5;
            this.retries = 0;
        }

        @Override
        public void run() {
            if (!CachingCommitGraphSource.this.isRunning()) {
                return;
            }
            try {
                this.streamCache();
            }
            catch (Exception e) {
                if (this.retries < this.maxRetries) {
                    ++this.retries;
                    CachingCommitGraphSource.this.executorService.execute(this);
                }
                log.warn("Failed to stream commit graph on {} after {} retries", new Object[]{this.repository.toString(), this.maxRetries, e});
            }
        }

        private void streamCache() throws IOException {
            String cacheKey = CachingCommitGraphSource.getCacheKey(this.repository);
            ContentProvider contentProvider = CachedCommitGraphUtils.getTimedScmContentProvider(this.repository, CachingCommitGraphSource.this.scmService, CachingCommitGraphSource.this.i18nService);
            CachingCommitGraphSource.this.contentCache.remove(cacheKey);
            try (CacheAccess cacheAccess = CachingCommitGraphSource.this.contentCache.access(cacheKey, this.outputStream, contentProvider);){
                if (cacheAccess.getResult() == CacheResult.MISS) {
                    cacheAccess.stream();
                }
            }
        }
    }
}

