/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.commit.graph.TraversalStatus;
import com.atlassian.bitbucket.commit.graph.TraversalSummary;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphOutputStream;
import com.atlassian.stash.internal.commit.graph.cache.CachedCommitGraphUtils;
import com.google.common.collect.Collections2;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

public class PersistingTraversalCallback
extends TraversalCallback
implements Closeable {
    private final OutputStream outputStream;
    private final I18nService i18nService;

    public PersistingTraversalCallback(OutputStream outputStream, I18nService i18nService) {
        this.outputStream = outputStream;
        this.i18nService = i18nService;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public TraversalStatus onNode(@Nonnull CommitGraphNode node) {
        String commitId = node.getCommit().getId();
        Collection parentCommitIds = Collections2.transform((Collection)node.getParents(), MinimalCommit::getId);
        try {
            this.outputStream.write(CachedCommitGraphUtils.getCommitIdAsByteArray(commitId));
            this.outputStream.write(CachedCommitGraphUtils.getCountAsByteArray(parentCommitIds.size()));
            for (String parentCommitId : parentCommitIds) {
                this.outputStream.write(CachedCommitGraphUtils.getCommitIdAsByteArray(parentCommitId));
            }
        }
        catch (CachedCommitGraphOutputStream.CachedCommitGraphOutputStreamIOException e) {
            return TraversalStatus.FINISH;
        }
        catch (IOException e) {
            throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.commit.graph.traversal.write.unexpectedioexception", new Object[0]), (Throwable)e);
        }
        return TraversalStatus.CONTINUE;
    }

    public void onEnd(@Nonnull TraversalSummary summary) {
        super.onEnd(summary);
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.commit.graph.traversal.flush.unexpectedioexception", new Object[0]), (Throwable)e);
        }
    }
}

