/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.util.contentcache.ContentProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Objects;

public class TimedContentProvider
implements ContentProvider {
    private final String name;
    private final ContentProvider delegate;

    public TimedContentProvider(String name, ContentProvider delegate) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(delegate, "delegate");
        this.name = name;
        this.delegate = delegate;
    }

    public void apply(OutputStream out) throws IOException {
        try (Timer timer = TimerUtils.start((String)this.name);){
            this.delegate.apply(out);
        }
    }

    public Date getExpiry() {
        return this.delegate.getExpiry();
    }
}

