/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.compare;

import com.atlassian.bitbucket.commit.BatchingCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.compare.CompareDiffRequest;
import com.atlassian.bitbucket.compare.CompareDiffStatsSummaryRequest;
import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.compare.CompareService;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.dmz.commit.DmzCommitEnricher;
import com.atlassian.bitbucket.event.compare.DiffSuccessfulEvent;
import com.atlassian.bitbucket.scm.compare.CompareChangeCommandParameters;
import com.atlassian.bitbucket.scm.compare.CompareDiffCommandParameters;
import com.atlassian.bitbucket.scm.compare.CompareDiffStatsSummaryCommandParameters;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.content.DiffContentCallbackFilter;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.internal.scm.InternalScmService;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=CompareService.class)
@PreAuthorize(value="isRepositoryAccessible(#request.fromRef.repository) and isRepositoryAccessible(#request.toRef.repository)")
@Service(value="compareService")
public class DefaultCompareService
extends AbstractScmService
implements CompareService {
    private final DmzCommitEnricher commitEnricher;
    private final EventPublisher eventPublisher;

    @Autowired
    public DefaultCompareService(InternalScmService scmService, DmzCommitEnricher commitEnricher, EventPublisher eventPublisher) {
        super(scmService);
        this.commitEnricher = commitEnricher;
        this.eventPublisher = eventPublisher;
    }

    @Nonnull
    public DiffStatsSummary getDiffStatsSummary(@Nonnull CompareDiffStatsSummaryRequest request) {
        Objects.requireNonNull(request, "request");
        return (DiffStatsSummary)this.scmService.getCompareCommandFactory(DefaultCompareService.asCompare(request)).diffStatsSummary(((CompareDiffStatsSummaryCommandParameters.Builder)((CompareDiffStatsSummaryCommandParameters.Builder)new CompareDiffStatsSummaryCommandParameters.Builder().paths((Iterable)request.getPaths())).whitespace(request.getWhitespace())).build()).call();
    }

    public void streamChanges(@Nonnull CompareRequest request, @Nonnull ChangeCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        this.scmService.getCompareCommandFactory(request).changes(((CompareChangeCommandParameters.Builder)new CompareChangeCommandParameters.Builder().maxChanges(this.maxChanges)).build(), callback).call();
    }

    public void streamCommits(final @Nonnull CompareRequest request, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        this.scmService.getCompareCommandFactory(request).commits((CommitCallback)new BatchingCommitCallback(callback, 25){

            protected boolean onCommits(@Nonnull Iterable<Commit> commits) throws IOException {
                commits = DefaultCompareService.this.commitEnricher.enrichAll(request.getFromRef().getRepository(), commits, Collections.emptySet());
                return super.onCommits(commits);
            }
        }).call();
    }

    public void streamDiff(@Nonnull CompareDiffRequest request, @Nonnull DiffContentCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(request, "callback");
        this.scmService.getCompareCommandFactory(DefaultCompareService.asCompare(request)).diff(((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)((CompareDiffCommandParameters.Builder)new CompareDiffCommandParameters.Builder().contextLines(request.hasContextLines() ? request.getContextLines() : this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths((Iterable)request.getPaths())).whitespace(request.getWhitespace())).build(), DiffContentCallbackFilter.filter((DiffContentCallback)callback, (DiffContentFilter)request.getFilter())).call();
        this.eventPublisher.publish((Object)new DiffSuccessfulEvent((Object)this, request.getFromRef(), request.getToRef()));
    }

    private static CompareRequest asCompare(CompareDiffRequest request) {
        return new CompareRequest.Builder(request).build();
    }

    private static CompareRequest asCompare(CompareDiffStatsSummaryRequest request) {
        return new CompareRequest.Builder(request).build();
    }
}

