/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.nutcluster.BaseEntryProcessor;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.serialization.OsgiSafe;
import com.atlassian.nutcluster.spring.context.SpringAware;
import com.atlassian.stash.internal.concurrent.BucketKey;
import com.atlassian.stash.internal.concurrent.TaskBucket;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@SpringAware
class ClaimTasksFromBucketProcessor<T>
extends BaseEntryProcessor<BucketKey, TaskBucket<OsgiSafe<T>>> {
    private static final Logger log = LoggerFactory.getLogger(ClaimTasksFromBucketProcessor.class);
    private final String nodeId;
    private final int numberToTake;
    private transient NutclusterInstance nutcluster;

    ClaimTasksFromBucketProcessor(String nodeId, int numberToTake) {
        this.nodeId = nodeId;
        this.numberToTake = numberToTake;
    }

    public List<OsgiSafe<T>> process(Map.Entry<BucketKey, TaskBucket<OsgiSafe<T>>> entry) {
        TaskBucket<OsgiSafe<T>> bucket = entry.getValue();
        if (bucket == null || bucket.isEmpty()) {
            return Collections.emptyList();
        }
        String executingNode = bucket.getExecutingNode().orElse(null);
        if (executingNode != null) {
            if (executingNode.equals(this.nodeId)) {
                log.trace("Node {} is already executing bucket {}", (Object)this.nodeId, (Object)entry.getKey());
                return null;
            }
            if (this.isNodeInCluster(executingNode)) {
                long timeMs = System.currentTimeMillis() - bucket.getExecutionStart();
                if (timeMs < TimeUnit.HOURS.toMillis(4L)) {
                    log.debug("Task bucket '{}' is still executing on node {}. Waiting for the task to complete before this node takes over processing.", (Object)entry.getKey(), (Object)executingNode);
                    return null;
                }
                log.info("Task bucket '{}' is marked as executing on node {}, but the node is no longer the owner of the bucket. This node will take over processing for the task bucket", (Object)entry.getKey(), (Object)executingNode);
            } else {
                log.info("Task bucket '{}' is marked as executing on node {} but that node is no longer in the cluster. This node will take over processing for the task bucket", (Object)entry.getKey(), (Object)executingNode);
            }
        }
        bucket.setExecutingNode(this.nodeId);
        log.trace("Task bucket '{}' execution starting on node {}", (Object)entry.getKey(), (Object)this.nodeId);
        List<OsgiSafe<T>> result = bucket.take(this.numberToTake);
        entry.setValue(bucket);
        return result;
    }

    @Autowired
    public void setNutclusterInstance(NutclusterInstance nutcluster) {
        this.nutcluster = nutcluster;
    }

    private boolean isNodeInCluster(String nodeId) {
        return this.nutcluster != null && this.nutcluster.getCluster().getMembers().stream().map(Member::getUuid).anyMatch(uuid -> uuid.equals(nodeId));
    }
}

