/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.bitbucket.util.Operation;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ClusterMappedLock {
    private final ClusterLockService clusterLockService;
    private final String lockPrefix;

    public ClusterMappedLock(ClusterLockService clusterLockService, String mapName) {
        this.clusterLockService = clusterLockService;
        this.lockPrefix = mapName + "#";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> T withLock(@Nonnull String key, @Nonnull Operation<T, E> operation) throws E {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(operation, "operation");
        ClusterLock lock = this.clusterLockService.getLockForName(this.lockPrefix + key);
        lock.lock();
        try {
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }
}

