/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.bitbucket.concurrent.PullRequestLock;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.concurrent.ClusterMappedLock;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ClusterPullRequestLock
implements PullRequestLock {
    private static final String LOCK_PREFIX = "lock.bbs.pull.";
    private final ClusterMappedLock lock;

    public ClusterPullRequestLock(ClusterLockService clusterLockService, String lockName) {
        this.lock = new ClusterMappedLock(clusterLockService, LOCK_PREFIX + lockName);
    }

    public <T, E extends Exception> T withLock(int repositoryId, long pullRequestId, @Nonnull Operation<T, E> operation) throws E {
        return this.lock.withLock(repositoryId + "/" + pullRequestId, operation);
    }

    public <T, E extends Exception> T withLock(@Nonnull PullRequest pullRequest, @Nonnull Operation<T, E> operation) throws E {
        return this.withLock(Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository().getId(), pullRequest.getId(), operation);
    }
}

