/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.bitbucket.concurrent.RepositoryLock;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.concurrent.ClusterMappedLock;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ClusterRepositoryLock
implements RepositoryLock {
    private static final String LOCK_PREFIX = "lock.bbs.repo.";
    private final ClusterMappedLock lock;

    public ClusterRepositoryLock(ClusterLockService clusterLockService, String lockName) {
        this.lock = new ClusterMappedLock(clusterLockService, LOCK_PREFIX + lockName);
    }

    public <T, E extends Exception> T withLock(int repositoryId, @Nonnull Operation<T, E> operation) throws E {
        return this.lock.withLock(Integer.toString(repositoryId), operation);
    }

    public <T, E extends Exception> T withLock(@Nonnull Repository repository, @Nonnull Operation<T, E> operation) throws E {
        return this.lock.withLock(Integer.toString(Objects.requireNonNull(repository, "repository").getId()), operation);
    }
}

