/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.event.cluster.ClusterMembershipEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.concurrent.BucketedExecutorFactory;
import com.atlassian.stash.internal.concurrent.DelegatingInternalBucketedExecutor;
import com.atlassian.stash.internal.concurrent.InternalBucketedExecutor;
import com.atlassian.stash.internal.concurrent.InternalConcurrencyService;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ConcurrencyService.class)
@DefaultApplicationMode
@Service(value="concurrencyService")
public class DefaultConcurrencyService
implements InternalConcurrencyService {
    private final ConcurrentMap<String, InternalBucketedExecutor> bucketedExecutors;
    private final BucketedExecutorFactory executorFactory;
    private volatile boolean shutdown;

    @Autowired
    public DefaultConcurrencyService(BucketedExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
        this.bucketedExecutors = new ConcurrentHashMap<String, InternalBucketedExecutor>();
    }

    @Unsecured(value="This is an internal service method")
    public <T extends Serializable> InternalBucketedExecutor<T> getBucketedExecutor(@Nonnull String name) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"service has been shut down");
        return this.wrap((InternalBucketedExecutor)this.bucketedExecutors.get(Objects.requireNonNull(name, "name")), name);
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public <T extends Serializable> InternalBucketedExecutor<T> getBucketedExecutor(@Nonnull String name, @Nonnull BucketedExecutorSettings<T> settings) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"service has been shut down");
        Objects.requireNonNull(settings, "settings");
        InternalBucketedExecutor<T> executor = (InternalBucketedExecutor<T>)this.bucketedExecutors.get(Objects.requireNonNull(name, "name"));
        if (executor == null) {
            InternalBucketedExecutor<T> newExecutor = this.executorFactory.create(name, settings);
            executor = this.bucketedExecutors.putIfAbsent(name, newExecutor);
            if (executor == null) {
                executor = newExecutor;
            } else {
                newExecutor.shutdown();
            }
        }
        return this.wrap(executor, name);
    }

    @EventListener
    public void onNodeAddedOrRemoved(ClusterMembershipEvent event) {
        int nodeCount = event.getCurrentNodes().size();
        this.bucketedExecutors.values().forEach(executor -> executor.updateClusterSize(nodeCount));
    }

    @PreDestroy
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        for (InternalBucketedExecutor executor : Iterables.consumingIterable(this.bucketedExecutors.values())) {
            executor.shutdown();
        }
    }

    private <T extends Serializable> InternalBucketedExecutor<T> wrap(final InternalBucketedExecutor<T> executor, final String name) {
        return executor == null ? null : new DelegatingInternalBucketedExecutor<T>(executor){

            @Override
            public void shutdown() {
                super.shutdown();
                DefaultConcurrencyService.this.bucketedExecutors.remove(name, executor);
            }
        };
    }
}

