/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.event.cluster.ClusterMembershipEvent;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.concurrent.ExecutionIdManager;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import jakarta.annotation.Nonnull;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultExecutionIdManager
implements StatefulService,
ExecutionIdManager {
    private static final String NO_EXECUTION_ID = "";
    private static final byte[] SEED = new byte[]{-76, 86, 81, -108, -48, -37, 12, -123, 83, 115};
    private final AtomicLong executionCounter = new AtomicLong();
    private final ThreadLocal<String> executionIdThreadLocal = new ThreadLocal();
    private volatile boolean clustered;
    private volatile Object nodeId;

    @Nonnull
    public TransferableState getState() {
        final String executionId = this.executionIdThreadLocal.get();
        return new TransferableState(){

            public void apply() {
                DefaultExecutionIdManager.this.applyId(executionId);
            }

            public void remove() {
                DefaultExecutionIdManager.this.removeId(executionId);
            }
        };
    }

    @EventListener
    public void onClusterMembershipChanged(ClusterMembershipEvent event) {
        this.clustered = event.getCurrentNodes().size() > 1;
    }

    @Override
    public void run(Runnable runnable) {
        String id = this.maybeGenerateId();
        try {
            runnable.run();
        }
        finally {
            this.removeId(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T run(Operation<T, E> operation) throws E {
        String id = this.maybeGenerateId();
        try {
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            this.removeId(id);
        }
    }

    @Autowired
    public void setClusterService(ClusterService clusterService) {
        this.clustered = clusterService.isClustered();
        this.nodeId = DefaultExecutionIdManager.hashNodeId(clusterService.getNodeId());
    }

    private static String hashNodeId(String clusterNodeId) {
        CRC32 crc = new CRC32();
        crc.update(SEED);
        crc.update(DigestUtils.sha256((String)clusterNodeId));
        return Long.toString(crc.getValue(), 36).toUpperCase(Locale.US);
    }

    private void applyId(String executionId) {
        if (executionId != null && executionId != NO_EXECUTION_ID) {
            MDC.put((String)"a-request-id", (String)executionId);
        }
        this.executionIdThreadLocal.set(executionId);
    }

    private String maybeGenerateId() {
        Object id = this.executionIdThreadLocal.get();
        if (id == null) {
            String requestId = MDC.get((String)"a-request-id");
            if (requestId == null) {
                long count = this.executionCounter.incrementAndGet();
                id = (this.clustered ? "*" : "@") + String.valueOf(this.nodeId) + "x" + ZonedDateTime.now(ZoneOffset.UTC).get(ChronoField.MINUTE_OF_DAY) + "x" + count + "x0";
            } else {
                id = NO_EXECUTION_ID;
            }
            this.applyId((String)id);
        }
        return id;
    }

    private void removeId(String executionId) {
        if (executionId != null && executionId != NO_EXECUTION_ID) {
            MDC.remove((String)"a-request-id");
        }
        this.executionIdThreadLocal.remove();
    }
}

