/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.concurrent.PullRequestLock;
import com.atlassian.bitbucket.concurrent.RepositoryLock;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.concurrent.BootstrapLock;
import com.atlassian.stash.internal.concurrent.ClusterPullRequestLock;
import com.atlassian.stash.internal.concurrent.ClusterRepositoryLock;
import com.atlassian.stash.internal.concurrent.InternalLockService;
import com.atlassian.stash.internal.concurrent.LiquibaseBootstrapLock;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=LockService.class)
@Service(value="lockService")
public class DefaultLockService
implements InternalLockService {
    private final ClusterLockService clusterLockService;
    private final DataSource dataSource;
    private final I18nService i18nService;

    @Autowired
    public DefaultLockService(ClusterLockService clusterLockService, DataSource dataSource, I18nService i18nService) {
        this.clusterLockService = clusterLockService;
        this.dataSource = dataSource;
        this.i18nService = i18nService;
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public Lock getLock(@Nonnull String lockName) {
        return this.clusterLockService.getLockForName(Objects.requireNonNull(lockName, "lockName"));
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public PullRequestLock getPullRequestLock(@Nonnull String lockName) {
        return new ClusterPullRequestLock(this.clusterLockService, Objects.requireNonNull(lockName, "lockName"));
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public RepositoryLock getRepositoryLock(@Nonnull String lockName) {
        return new ClusterRepositoryLock(this.clusterLockService, Objects.requireNonNull(lockName, "lockName"));
    }

    @Nonnull
    @Unsecured(value="Available to internal code only")
    public BootstrapLock getBootstrapLock() {
        return new LiquibaseBootstrapLock(this.dataSource, this.i18nService);
    }
}

