/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.concurrent.MonitoredClusterLockService;
import jakarta.annotation.Nonnull;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;

public class DefaultMonitoredClusterLockService
implements MonitoredClusterLockService {
    private final ClusterLockService delegate;
    private final boolean jmxEnabled;
    private final AtomicLong totalLockedCount;
    private final AtomicLong totalLockErrorCount;
    private final AtomicLong totalLockWaitTimeNanos;
    private final AtomicLong totalUnlockedCount;
    private final AtomicLong totalUnlockErrorCount;
    private final AtomicInteger waitingForLockCount;

    public DefaultMonitoredClusterLockService(ClusterLockService delegate, boolean jmxEnabled) {
        this.delegate = delegate;
        this.jmxEnabled = jmxEnabled;
        this.totalLockedCount = new AtomicLong();
        this.totalLockErrorCount = new AtomicLong();
        this.totalUnlockErrorCount = new AtomicLong();
        this.totalUnlockedCount = new AtomicLong();
        this.totalLockWaitTimeNanos = new AtomicLong();
        this.waitingForLockCount = new AtomicInteger();
    }

    public long getLockedCount() {
        return this.totalLockedCount.get() - this.totalUnlockedCount.get();
    }

    public ClusterLock getLockForName(@Nonnull String lockName) {
        ClusterLock lock = this.delegate.getLockForName(lockName);
        return this.jmxEnabled ? new MonitoredClusterLock(lock) : lock;
    }

    public long getTotalAcquiredCount() {
        return this.totalLockedCount.get();
    }

    public long getTotalAcquireErrorCount() {
        return this.totalLockErrorCount.get();
    }

    public long getTotalReleasedCount() {
        return this.totalUnlockedCount.get();
    }

    public long getTotalReleaseErrorCount() {
        return this.totalUnlockErrorCount.get();
    }

    public long getTotalAcquireTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.totalLockWaitTimeNanos.get());
    }

    public int getQueuedThreadCount() {
        return this.waitingForLockCount.get();
    }

    private class MonitoredClusterLock
    implements ClusterLock {
        private final ClusterLock delegate;

        private MonitoredClusterLock(ClusterLock delegate) {
            this.delegate = delegate;
        }

        public boolean isHeldByCurrentThread() {
            return this.delegate.isHeldByCurrentThread();
        }

        public void lock() {
            this.trackWaiting(() -> {
                this.delegate.lock();
                DefaultMonitoredClusterLockService.this.totalLockedCount.incrementAndGet();
                return null;
            });
        }

        public void lockInterruptibly() throws InterruptedException {
            this.trackWaiting(() -> {
                this.delegate.lockInterruptibly();
                DefaultMonitoredClusterLockService.this.totalLockedCount.incrementAndGet();
                return null;
            });
        }

        public boolean tryLock() {
            return (Boolean)this.trackWaiting(() -> {
                if (this.delegate.tryLock()) {
                    DefaultMonitoredClusterLockService.this.totalLockedCount.incrementAndGet();
                    return true;
                }
                return false;
            });
        }

        public boolean tryLock(long time, @Nonnull TimeUnit unit) throws InterruptedException {
            return (Boolean)this.trackWaiting(() -> {
                if (this.delegate.tryLock(time, unit)) {
                    DefaultMonitoredClusterLockService.this.totalLockedCount.incrementAndGet();
                    return true;
                }
                return false;
            });
        }

        public void unlock() {
            boolean success = false;
            try {
                this.delegate.unlock();
                success = true;
                DefaultMonitoredClusterLockService.this.totalUnlockedCount.incrementAndGet();
            }
            finally {
                if (!success) {
                    DefaultMonitoredClusterLockService.this.totalUnlockErrorCount.incrementAndGet();
                }
            }
        }

        @Nonnull
        public Condition newCondition() {
            return this.delegate.newCondition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T, E extends Exception> T trackWaiting(Operation<T, E> operation) throws E {
            DefaultMonitoredClusterLockService.this.waitingForLockCount.incrementAndGet();
            boolean success = false;
            long start = System.nanoTime();
            try {
                Object result = operation.perform();
                success = true;
                Object object = result;
                return (T)object;
            }
            finally {
                DefaultMonitoredClusterLockService.this.totalLockWaitTimeNanos.addAndGet(System.nanoTime() - start);
                DefaultMonitoredClusterLockService.this.waitingForLockCount.decrementAndGet();
                if (!success) {
                    DefaultMonitoredClusterLockService.this.totalLockErrorCount.incrementAndGet();
                }
            }
        }
    }
}

