/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.InternalBucketedExecutor;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

class DelegatingInternalBucketedExecutor<T extends Serializable>
implements InternalBucketedExecutor<T> {
    private final InternalBucketedExecutor<T> executor;

    public DelegatingInternalBucketedExecutor(InternalBucketedExecutor<T> executor) {
        this.executor = executor;
    }

    public void scheduleLocally(@Nonnull String bucketId, long delay, @Nonnull TimeUnit timeUnit) {
        this.executor.scheduleLocally(bucketId, delay, timeUnit);
    }

    public void schedule(@Nonnull T task, long delay, @Nonnull TimeUnit timeUnit) {
        this.executor.schedule(task, delay, timeUnit);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void submit(@Nonnull T task) {
        this.executor.submit(task);
    }

    public void updateClusterSize(int nodeCount) {
        this.executor.updateClusterSize(nodeCount);
    }

    @VisibleForTesting
    InternalBucketedExecutor unwrap() {
        return this.executor;
    }
}

