/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.nutcluster.BaseEntryProcessor;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.DataSerializable;
import com.atlassian.nutcluster.serialization.OsgiSafe;
import com.atlassian.stash.internal.concurrent.BucketKey;
import com.atlassian.stash.internal.concurrent.TaskBucket;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

class FinishProcessingBucketProcessor<T>
extends BaseEntryProcessor<BucketKey, TaskBucket<OsgiSafe<T>>>
implements DataSerializable {
    private Collection<OsgiSafe<T>> returned;

    FinishProcessingBucketProcessor() {
    }

    FinishProcessingBucketProcessor(Collection<OsgiSafe<T>> returned) {
        this.returned = returned;
    }

    public Void process(Map.Entry<BucketKey, TaskBucket<OsgiSafe<T>>> entry) {
        TaskBucket<Object> bucket = entry.getValue();
        if (bucket == null) {
            if (this.returned == null || this.returned.isEmpty()) {
                return null;
            }
            bucket = new TaskBucket();
        }
        if (this.returned != null && !this.returned.isEmpty()) {
            bucket.returnAll(this.returned);
        }
        bucket.setExecutingNode(null);
        entry.setValue(bucket.isEmpty() ? null : bucket);
        return null;
    }

    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.returned = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            this.returned.add((OsgiSafe)in.readObject());
        }
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        if (this.returned == null || this.returned.isEmpty()) {
            out.writeInt(0);
        } else {
            out.writeInt(this.returned.size());
            for (OsgiSafe<T> value : this.returned) {
                out.writeObject(value);
            }
        }
    }
}

