/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.concurrent.BootstrapLock;
import com.atlassian.stash.internal.concurrent.LockException;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.lockservice.LockService;
import liquibase.lockservice.StandardLockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseBootstrapLock
implements BootstrapLock {
    private static final Logger log = LoggerFactory.getLogger(LiquibaseBootstrapLock.class);
    private final DataSource dataSource;
    private final I18nService i18nService;

    public LiquibaseBootstrapLock(DataSource dataSource, I18nService i18nService) {
        this.dataSource = dataSource;
        this.i18nService = i18nService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T withLock(@Nonnull Operation<T, E> operation) throws E {
        Objects.requireNonNull(operation, "operation");
        Database database = this.findDatabase(this.dataSource);
        LockService service = this.getLockService(database);
        log.debug("Acquiring database lock");
        try {
            service.waitForLock();
            log.debug("Database lock acquired");
        }
        catch (Exception e) {
            throw new LockException(this.i18nService.createKeyedMessage("bitbucket.service.lock.bootstrap.acquirefailed", new Object[0]), (Throwable)e);
        }
        try {
            log.debug("Performing operation");
            Object object = operation.perform();
            return (T)object;
        }
        finally {
            try {
                log.debug("Releasing database lock");
                service.releaseLock();
                log.debug("Database lock released");
            }
            catch (liquibase.exception.LockException e) {
                throw new LockException(this.i18nService.createKeyedMessage("bitbucket.service.lock.bootstrap.releasefailed", new Object[0]), (Throwable)e);
            }
            finally {
                this.closeDatabase(database);
            }
        }
    }

    @Nonnull
    @VisibleForTesting
    Database findDatabase(@Nonnull DataSource dataSource) {
        return LiquibaseUtils.findDatabase((DataSource)dataSource);
    }

    @Nonnull
    @VisibleForTesting
    LockService getLockService(@Nonnull Database database) {
        StandardLockService lockService = new StandardLockService();
        lockService.setDatabase(database);
        return lockService;
    }

    private void closeDatabase(Database database) {
        try {
            database.close();
        }
        catch (DatabaseException e) {
            log.error("Failed to close database", (Throwable)e);
        }
    }
}

