/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.nutcluster.core.Cluster;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.serialization.OsgiSafe;
import com.atlassian.stash.internal.concurrent.BucketKey;
import com.atlassian.stash.internal.concurrent.ClaimTasksFromBucketProcessor;
import com.atlassian.stash.internal.concurrent.FinishProcessingBucketProcessor;
import com.atlassian.stash.internal.concurrent.InternalBucketedExecutor;
import com.atlassian.stash.internal.concurrent.SubmitTaskToBucketProcessor;
import com.atlassian.stash.internal.concurrent.TaskBucket;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NutclusterBucketedExecutor<T extends Serializable>
implements InternalBucketedExecutor<T> {
    private static final Logger log = LoggerFactory.getLogger(NutclusterBucketedExecutor.class);
    private final IMap<BucketKey, TaskBucket<OsgiSafe<T>>> bucketMap;
    private final Cluster cluster;
    private final ScheduledThreadPoolExecutor executor;
    private final String name;
    private final String nodeId;
    private final BucketedExecutorSettings<T> settings;
    private final Function<OsgiSafe<T>, T> unwrapFunction;

    public NutclusterBucketedExecutor(String name, BucketedExecutorSettings<T> settings, NutclusterInstance nutcluster, ThreadFactory threadFactory) {
        this.name = name;
        this.settings = settings;
        this.bucketMap = nutcluster.getMap("bucketed.executor.tasks");
        this.cluster = nutcluster.getCluster();
        this.executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        this.nodeId = this.cluster.getLocalMember().getUuid();
        this.unwrapFunction = OsgiSafe::getValue;
        this.updateClusterSize(nutcluster.getCluster().getMembers().size());
    }

    public void schedule(@Nonnull T task, long delay, @Nonnull TimeUnit timeUnit) {
        String bucketId = (String)this.settings.getBucketIdExtractor().apply(task);
        this.bucketMap.submitToKey((Object)new BucketKey(this.name, bucketId), new SubmitTaskToBucketProcessor(this.name, new OsgiSafe(task), delay, timeUnit, this));
    }

    public void scheduleLocally(@Nonnull String bucketId, long delay, @Nonnull TimeUnit timeUnit) {
        BucketProcessingBootstrapper bootstrapper = new BucketProcessingBootstrapper(new BucketKey(this.name, bucketId));
        if (delay <= 0L) {
            this.executor.submit(bootstrapper);
        } else {
            this.executor.schedule(bootstrapper, delay, timeUnit);
        }
    }

    public void shutdown() {
        ExecutorUtils.shutdown((ExecutorService)this.executor, (Logger)log);
    }

    public void submit(@Nonnull T task) {
        this.schedule(task, 0L, TimeUnit.SECONDS);
    }

    public void updateClusterSize(int nodeCount) {
        int poolSize = this.getPoolSize(nodeCount);
        if (poolSize > this.executor.getMaximumPoolSize()) {
            this.executor.setMaximumPoolSize(poolSize);
            this.executor.setCorePoolSize(poolSize);
        } else {
            this.executor.setCorePoolSize(poolSize);
            this.executor.setMaximumPoolSize(poolSize);
        }
    }

    @VisibleForTesting
    void shutdownNow() {
        this.executor.shutdownNow();
    }

    private int getPoolSize(int numberOfNodes) {
        if (this.settings.getMaxConcurrencyPolicy() == ConcurrencyPolicy.PER_NODE) {
            return this.settings.getMaxConcurrency();
        }
        return (int)Math.ceil((double)this.settings.getMaxConcurrency() / (1.0 * (double)numberOfNodes));
    }

    private class BucketProcessingBootstrapper
    implements Runnable {
        private final BucketKey bucketKey;
        private int attempt = 1;

        private BucketProcessingBootstrapper(BucketKey bucketKey) {
            this.bucketKey = bucketKey;
        }

        @Override
        public void run() {
            List toBeProcessed = (List)NutclusterBucketedExecutor.this.bucketMap.executeOnKey((Object)this.bucketKey, new ClaimTasksFromBucketProcessor(NutclusterBucketedExecutor.this.nodeId, NutclusterBucketedExecutor.this.settings.getBatchSize()));
            if (toBeProcessed == null) {
                NutclusterBucketedExecutor.this.executor.schedule(this, 1L, TimeUnit.SECONDS);
                return;
            }
            if (toBeProcessed.isEmpty()) {
                return;
            }
            try {
                log.trace("Processing bucket '{}' of executor '{}'. Attempt {} of {}", new Object[]{this.bucketKey, NutclusterBucketedExecutor.this.name, this.attempt, NutclusterBucketedExecutor.this.settings.getMaxAttempts()});
                NutclusterBucketedExecutor.this.settings.getProcessor().process(this.bucketKey.getBucketId(), Chainable.chain((Iterable)toBeProcessed).transform(NutclusterBucketedExecutor.this.unwrapFunction).filter(Objects::nonNull).toList());
                log.trace("Completed processing bucket '{}' of executor '{}'", (Object)this.bucketKey, (Object)NutclusterBucketedExecutor.this.name);
                toBeProcessed = null;
            }
            catch (Error e) {
                log.error("Attempt {} of {} at processing bucket '{}' for executor '{}' caused an error. Processing will not be reattempted", new Object[]{this.attempt, NutclusterBucketedExecutor.this.settings.getMaxAttempts(), this.bucketKey, NutclusterBucketedExecutor.this.name, e});
                toBeProcessed = null;
                throw e;
            }
            catch (Exception e) {
                if (this.attempt < NutclusterBucketedExecutor.this.settings.getMaxAttempts()) {
                    log.info("Attempt {} of {} at processing bucket '{}' for executor '{}' failed: '{}'", new Object[]{this.attempt, NutclusterBucketedExecutor.this.settings.getMaxAttempts(), this.bucketKey, NutclusterBucketedExecutor.this.name, e.getMessage()});
                    log.debug("Exception:", (Throwable)e);
                    ++this.attempt;
                } else {
                    log.error("Attempt {} of {} at processing bucket '{}' for executor '{}' failed: ", new Object[]{this.attempt, NutclusterBucketedExecutor.this.settings.getMaxAttempts(), this.bucketKey, NutclusterBucketedExecutor.this.name, e});
                    toBeProcessed = null;
                }
            }
            finally {
                NutclusterBucketedExecutor.this.bucketMap.executeOnKey((Object)this.bucketKey, new FinishProcessingBucketProcessor(toBeProcessed));
                if (toBeProcessed != null) {
                    NutclusterBucketedExecutor.this.executor.schedule(this, 1L, TimeUnit.SECONDS);
                }
            }
        }
    }
}

