/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.stash.internal.concurrent.BucketedExecutorFactory;
import com.atlassian.stash.internal.concurrent.ConfigurableThreadFactory;
import com.atlassian.stash.internal.concurrent.InternalBucketedExecutor;
import com.atlassian.stash.internal.concurrent.NutclusterBucketedExecutor;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.concurrent.ThreadFactory;

public class NutclusterBucketedExecutorFactory
implements BucketedExecutorFactory {
    private final ClassLoader classLoader;
    private final NutclusterInstance nutcluster;
    private final ThreadGroup threadGroup;

    public NutclusterBucketedExecutorFactory(ClassLoader classLoader, NutclusterInstance nutcluster, ThreadGroup threadGroup) {
        this.classLoader = classLoader;
        this.nutcluster = nutcluster;
        this.threadGroup = threadGroup;
    }

    @Override
    @Nonnull
    public <T extends Serializable> InternalBucketedExecutor<T> create(@Nonnull String name, @Nonnull BucketedExecutorSettings<T> settings) {
        ConfigurableThreadFactory threadFactory = new ConfigurableThreadFactory(this.classLoader);
        threadFactory.setDaemon(true);
        threadFactory.setThreadGroup(this.threadGroup);
        threadFactory.setThreadNamePrefix(name);
        return new NutclusterBucketedExecutor<T>(name, settings, this.nutcluster, (ThreadFactory)threadFactory);
    }
}

