/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.stash.internal.config.ConfigurationAmendment;
import com.google.common.io.LineProcessor;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class ConfigurationLineProcessor
implements LineProcessor<Void> {
    private final Writer writer;
    private final ConfigurationAmendment amendment;

    public ConfigurationLineProcessor(@Nonnull Writer writer, @Nonnull ConfigurationAmendment amendment) {
        this.writer = Objects.requireNonNull(writer, "writer");
        this.amendment = Objects.requireNonNull(amendment, "amendment");
    }

    public boolean processLine(@Nonnull String line) throws IOException {
        if (this.amendment.isAmendable(line)) {
            this.amendment.amend(this.writer, line);
        } else {
            this.writeLine(line);
        }
        return true;
    }

    @Nonnull
    public Void getResult() {
        return null;
    }

    private void writeLine(@Nonnull String line) throws IOException {
        this.writer.write(line);
        this.writer.write(10);
    }
}

