/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.stash.internal.config.AbstractConfigurationAmendment;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.config.SecuredConfigurationPropertyCallback;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigurationSecretsAmendment
extends AbstractConfigurationAmendment {
    private final SecuredConfigurationPropertyCallback callback;
    private final Set<String> secretProperties;

    public ConfigurationSecretsAmendment(@Nonnull Clock clock, @Nonnull SecuredConfigurationPropertyCallback callback, @Nonnull Set<String> secretProperties) {
        super(clock);
        this.callback = Objects.requireNonNull(callback, "callback");
        this.secretProperties = Objects.requireNonNull(secretProperties, "secretProperties");
    }

    @Override
    public void amend(@Nonnull Writer writer, @Nonnull String line) throws IOException {
        Optional<Pair<String, String>> maybeProperty = this.getPropertyForLine(line);
        if (maybeProperty.isPresent()) {
            Pair<String, String> property = maybeProperty.get();
            this.callback.onPropertySecured((String)property.getKey(), (String)property.getValue());
            this.writeLine(writer, this.generateComment((String)property.getKey(), this.getClock()));
            this.writeLine(writer, String.format("%s=%s", property.getKey(), "{ATL_SECURED}"));
        }
    }

    @Override
    public boolean isAmendable(@Nonnull String line) {
        return this.getPropertyForLine(line).map(this::isPropertyAmendable).orElse(false);
    }

    private String generateComment(String propertyKey, Clock clock) {
        return String.format("#> %s secured on %s", propertyKey, DATE_TIME_FORMATTER.format(clock.now()));
    }

    private Optional<Pair<String, String>> getPropertyForLine(String line) {
        Optional<Pair<String, String>> optional;
        BufferedReader reader = new BufferedReader(new StringReader(line));
        try {
            Properties props = new Properties();
            props.load(reader);
            optional = props.stringPropertyNames().stream().findFirst().map(key -> Pair.of((Object)key, (Object)props.getProperty((String)key)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((Reader)reader).close();
        return optional;
    }

    private boolean isPropertyAmendable(Pair<String, String> property) {
        return this.secretProperties.contains(property.getKey()) && !"{ATL_SECURED}".equals(property.getValue());
    }
}

