/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.config.DataSourcePropertySerializer;
import com.atlassian.stash.internal.config.RemovePropertiesAmendment;
import com.atlassian.stash.internal.db.DatabaseConstants;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class DataSourceConfigurationAmendment
extends RemovePropertiesAmendment {
    private final DataSourceConfiguration dataSourceConfig;
    private final String message;
    private final ApplicationUser user;
    private boolean isOutputAmended;

    public DataSourceConfigurationAmendment(@Nonnull DataSourceConfiguration dataSourceConfig, @Nonnull String message, @Nonnull Clock clock, @Nullable ApplicationUser user) {
        super(clock, DatabaseConstants.PROPS_JDBC);
        this.dataSourceConfig = Objects.requireNonNull(dataSourceConfig, "dataSourceConfig");
        this.message = Objects.requireNonNull(message, "message");
        this.user = user;
    }

    @Override
    public boolean isAmendable(@Nonnull String line) {
        return this.isCommentBlockLine(line) || this.isAmendableProperty(line);
    }

    @Override
    public void amend(@Nonnull Writer writer, @Nonnull String line) throws IOException {
        if (!this.isOutputAmended) {
            this.isOutputAmended = true;
            this.addPropertiesSection(writer);
        }
        if (this.isAmendableProperty(line)) {
            this.commentOut(line, writer);
        }
    }

    @Override
    public void finalize(@Nonnull Writer writer) throws IOException {
        if (!this.isOutputAmended) {
            this.addPropertiesSection(writer);
        }
    }

    private void addPropertiesSection(Writer writer) throws IOException {
        this.writeCommentBlock(writer);
        this.writePropertyStrings(writer);
    }

    private void commentOut(String line, Writer writer) throws IOException {
        this.writeLine(writer, String.format("# %s", line));
    }

    private boolean isCommentBlockLine(String line) {
        return line.trim().startsWith("#>");
    }

    private void writePropertyStrings(Writer writer) throws IOException {
        DataSourcePropertySerializer serializer = new DataSourcePropertySerializer(this.dataSourceConfig);
        serializer.writeTo(writer);
    }

    private void writeCommentBlock(Writer writer) throws IOException {
        this.writeLine(writer, "#>*******************************************************");
        this.writeLine(writer, "#> " + this.message);
        this.writeLine(writer, this.formatUpdateTimestamp());
        this.writeLine(writer, "#>*******************************************************");
    }

    private String formatUpdateTimestamp() {
        StringBuilder builder = new StringBuilder("#> Updated");
        if (this.user != null) {
            builder.append(" by ").append(this.user.getDisplayName());
        }
        builder.append(" on ").append(DATE_TIME_FORMATTER.format(this.getClock().now()));
        return builder.toString();
    }
}

