/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;

public class DataSourcePropertySerializer {
    private final DataSourceConfiguration config;

    public DataSourcePropertySerializer(@Nonnull DataSourceConfiguration config) {
        this.config = Objects.requireNonNull(config, "config");
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.driverClassName());
        writer.write(this.url());
        writer.write(this.user());
        writer.write(this.password());
    }

    private String driverClassName() {
        return DataSourcePropertySerializer.keyValueString("jdbc.driver", this.config.getDriverClassName());
    }

    private String password() {
        return DataSourcePropertySerializer.keyValueString("jdbc.password", this.config.getPassword());
    }

    private String url() {
        return DataSourcePropertySerializer.keyValueString("jdbc.url", this.config.getUrl());
    }

    private String user() {
        return DataSourcePropertySerializer.keyValueString("jdbc.user", this.config.getUser());
    }

    private static String keyValueString(String key, String value) {
        return String.format("%s=%s\n", key, value == null ? "" : StringEscapeUtils.escapeJava((String)value));
    }
}

