/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.FilePermission;
import com.atlassian.bitbucket.util.FileUtils;
import com.atlassian.bitbucket.util.SetFilePermissionRequest;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.config.ConfigurationAmendment;
import com.atlassian.stash.internal.config.ConfigurationLineProcessor;
import com.atlassian.stash.internal.config.ConfigurationSecretsAmendment;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.config.DataSourceConfigurationAmendment;
import com.atlassian.stash.internal.config.DataSourceConfigurationSavedEvent;
import com.atlassian.stash.internal.config.DeprecateConfigurationRequest;
import com.atlassian.stash.internal.config.DeprecatePropertiesAmendment;
import com.atlassian.stash.internal.config.FileOperationException;
import com.atlassian.stash.internal.config.RemovePropertiesAmendment;
import com.atlassian.stash.internal.config.RemoveSetupConfigurationRequest;
import com.atlassian.stash.internal.config.SecuredConfigurationPropertyCallback;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.SimpleDataSourceConfiguration;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.LineProcessor;
import jakarta.annotation.Nonnull;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

@Service(value="configurationService")
public class DefaultConfigurationService
implements ConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigurationService.class);
    private final AuthenticationContext authenticationContext;
    private final Clock clock;
    private final EventPublisher eventPublisher;
    private final Path sharedHomeDir;
    private final I18nService i18nService;
    private final TransactionSynchronizer synchronizer;

    @Autowired
    public DefaultConfigurationService(@Value(value="#{homeLayout.sharedHomeDir}") Path sharedHomeDir, AuthenticationContext authenticationContext, Clock clock, I18nService i18nService, TransactionSynchronizer synchronizer, EventPublisher eventPublisher) {
        this.authenticationContext = Objects.requireNonNull(authenticationContext, "authenticationContext");
        this.clock = Objects.requireNonNull(clock, "clock");
        this.sharedHomeDir = Objects.requireNonNull(sharedHomeDir, "sharedHomeDir");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.synchronizer = synchronizer;
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
    }

    @Nonnull
    public DataSourceConfiguration loadDataSourceConfiguration() {
        Properties properties = this.loadCurrentConfig();
        return new SimpleDataSourceConfiguration(properties.getProperty("jdbc.driver"), properties.getProperty("jdbc.url"), properties.getProperty("jdbc.user"), properties.getProperty("jdbc.password"));
    }

    public void removeMergeStrategyProperties(@Nonnull DeprecateConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        try {
            this.applyAmendment(new DeprecatePropertiesAmendment(this.clock, request.getProperties(), request.getDeprecationMessage()));
        }
        catch (IOException e) {
            throw this.newFileOperationException("bitbucket.configuration.merge.strategies.removefailed", e);
        }
    }

    public void removeSetupProperties(@Nonnull RemoveSetupConfigurationRequest request) {
        Objects.requireNonNull(request, "request");
        try {
            this.applyAmendment(new RemovePropertiesAmendment(this.clock, request.toProperties()));
        }
        catch (IOException e) {
            throw this.newFileOperationException("bitbucket.configuration.setup.removefailed", e);
        }
    }

    public void saveDataSourceConfiguration(@Nonnull DataSourceConfiguration dataSourceConfig, @Nonnull String message) {
        Objects.requireNonNull(dataSourceConfig, "dataSourceConfig");
        Objects.requireNonNull(message, "message");
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        DataSourceConfigurationAmendment amendment = new DataSourceConfigurationAmendment(dataSourceConfig, message, this.clock, currentUser);
        try {
            this.applyAmendment(amendment);
            Path configFile = this.getConfigFile();
            try {
                FileUtils.setFilePermission((SetFilePermissionRequest)new SetFilePermissionRequest.Builder(configFile).ownerPermissions((Iterable)ImmutableSet.of((Object)FilePermission.READ, (Object)FilePermission.WRITE)).groupPermissions((Iterable)ImmutableSet.of((Object)FilePermission.READ)).build());
            }
            catch (IOException e) {
                log.warn("Could not restrict file permissions on config file {}", (Object)configFile.toAbsolutePath(), (Object)e);
            }
        }
        catch (IOException e) {
            throw this.newFileOperationException("bitbucket.configuration.setup.datasourcefailed", e);
        }
        this.eventPublisher.publish((Object)new DataSourceConfigurationSavedEvent(this));
    }

    public void secureSecretProperties(@Nonnull SecuredConfigurationPropertyCallback callback, @Nonnull Set<String> secretProperties) {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(secretProperties, "secretProperties");
        try {
            this.applyAmendment(new ConfigurationSecretsAmendment(this.clock, callback, secretProperties));
        }
        catch (IOException e) {
            throw this.newFileOperationException("bitbucket.configuration.secrets.securefailed", e);
        }
    }

    @VisibleForTesting
    void applyAmendment(ConfigurationAmendment amendment) throws IOException {
        Path original = this.getConfigFile();
        Path draft = this.createDraftConfigFile();
        Path backup = null;
        try {
            try (BufferedWriter draftWriter = this.openFile(draft);){
                if (Files.exists(original, new LinkOption[0])) {
                    backup = this.getBackUpConfigFile(original);
                    com.google.common.io.Files.readLines((File)original.toFile(), (Charset)StandardCharsets.UTF_8, (LineProcessor)new ConfigurationLineProcessor(draftWriter, amendment));
                }
                amendment.finalize(draftWriter);
            }
            this.swapConfigFile(original, draft, backup);
        }
        catch (FileOperationException | IOException e) {
            this.deleteFile(draft);
            if (backup != null) {
                this.deleteFile(backup);
            }
            throw e;
        }
    }

    private void deleteFile(Path file) {
        try {
            Files.delete(file);
        }
        catch (IOException e) {
            log.warn("Failed to delete {}. Setting it to delete upon exit", (Object)file.toAbsolutePath(), (Object)e);
            file.toFile().deleteOnExit();
        }
    }

    private FileOperationException newFileOperationException(String i18nKey, IOException e) {
        String configurationFilePath = this.getConfigFile().toAbsolutePath().toString();
        return new FileOperationException(this.i18nService.createKeyedMessage(i18nKey, new Object[]{configurationFilePath}), e);
    }

    private void swapConfigFile(final Path original, Path draft, final Path backup) {
        this.rename(draft, original);
        this.synchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCompletion(int status) {
                if (status == 1 || status == 2) {
                    log.warn("Transaction was rolled back or is in an unknown state. Restoring original {} file (if available)", (Object)"bitbucket.properties");
                    if (backup != null) {
                        DefaultConfigurationService.this.rename(backup, original);
                    }
                }
            }
        });
    }

    private void rename(Path src, Path dst) {
        try {
            Files.move(src, dst, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.configuration.draft.rename", new Object[]{src, dst});
            throw new FileOperationException(message, e);
        }
    }

    @VisibleForTesting
    Path getBackUpConfigFile(Path original) {
        Path backupFile = original.resolveSibling(original.getFileName().toString() + ".bak");
        try {
            Files.copy(original, backupFile, StandardCopyOption.REPLACE_EXISTING);
            return backupFile;
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.configuration.configCopyFail", new Object[]{original, backupFile, Product.NAME});
            throw new FileOperationException(message, e);
        }
    }

    private Path getConfigFile() {
        return this.sharedHomeDir.resolve("bitbucket.properties");
    }

    private Path createDraftConfigFile() {
        try {
            return Files.createTempFile(this.sharedHomeDir, "draft", "properties", new FileAttribute[0]);
        }
        catch (IOException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.configuration.tempFile.create", new Object[0]);
            throw new FileOperationException(message, e);
        }
    }

    private Properties loadCurrentConfig() {
        Resource[] configResources = new Resource[]{new ClassPathResource("application-internal.properties"), new ClassPathResource("application-default.properties"), new PathResource(this.getConfigFile())};
        Properties properties = new Properties();
        for (Resource resource : configResources) {
            try {
                PropertiesLoaderUtils.fillProperties((Properties)properties, (Resource)resource);
            }
            catch (IOException e) {
                log.warn("Problem loading properties from {}", (Object)resource.getFilename(), (Object)e);
            }
        }
        return properties;
    }

    private BufferedWriter openFile(Path file) throws IOException {
        try {
            return Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.configuration.tempFile.notFound", new Object[]{file});
            throw new FileOperationException(message, e);
        }
    }
}

