/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.config.RemovePropertiesAmendment;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.Set;

public class DeprecatePropertiesAmendment
extends RemovePropertiesAmendment {
    private final String deprecationMessage;
    private boolean deprecationAdded;

    public DeprecatePropertiesAmendment(@Nonnull Clock clock, @Nonnull Set<String> properties, @Nonnull String deprecationMessage) {
        super(clock, properties);
        this.deprecationMessage = Objects.requireNonNull(deprecationMessage, "deprecationMessage");
        Preconditions.checkArgument((boolean)deprecationMessage.startsWith("#"), (Object)"Deprecation message must start with a '#'");
    }

    @Override
    public void amend(@Nonnull Writer writer, @Nonnull String line) throws IOException {
        if (!this.deprecationAdded) {
            this.writeLine(writer, this.deprecationMessage);
            this.deprecationAdded = true;
        }
        this.writeLine(writer, "# " + line);
    }
}

