/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.property.PropertySupport;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractProviderContext<E extends PropertySupport> {
    protected final Set<E> attributeHolders;
    protected final Map<E, PropertyMap.Builder> properties;

    protected AbstractProviderContext(Set<? extends E> attributeHolders) {
        this.attributeHolders = attributeHolders;
        this.properties = new HashMap<E, PropertyMap.Builder>();
    }

    public Iterator<E> iterator() {
        return this.attributeHolders.iterator();
    }

    @Nonnull
    public PropertyMap getPropertiesFor(@Nonnull E entity) {
        PropertyMap.Builder builder = this.properties.get(entity);
        return builder == null ? PropertyMap.EMPTY : builder.build();
    }

    public void setProperty(@Nonnull E entity, @Nonnull String key, @Nonnull Object value) {
        Objects.requireNonNull(entity, "entity");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        PropertyMap.Builder builder = this.properties.get(entity);
        if (builder == null) {
            builder = new PropertyMap.Builder();
            this.properties.put(entity, builder);
        }
        builder.property(key, value);
    }
}

