/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.content.ArchiveRequest;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.EditFileRequest;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.content.FileContext;
import com.atlassian.bitbucket.content.FileSummary;
import com.atlassian.bitbucket.content.NoSuchPathException;
import com.atlassian.bitbucket.content.PatchRequest;
import com.atlassian.bitbucket.content.SimpleBlame;
import com.atlassian.bitbucket.event.content.FileEditedEvent;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoSuchBranchException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchivedException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.SimpleBranch;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.ArchiveCommandParameters;
import com.atlassian.bitbucket.scm.BlameCommandParameters;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.DirectoryCommandParameters;
import com.atlassian.bitbucket.scm.EditFileCommandParameters;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.bitbucket.scm.FileCommandParameters;
import com.atlassian.bitbucket.scm.PatchCommandParameters;
import com.atlassian.bitbucket.scm.RawFileCommandParameters;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.SizeCommandParameters;
import com.atlassian.bitbucket.scm.TypeCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Throttled;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.content.ContentArchiveFailedEvent;
import com.atlassian.stash.internal.content.ContentArchiveSuccessfulEvent;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalUserService;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=ContentService.class)
@PreAuthorize(value="isRepositoryAccessible(#repository)")
@Service(value="contentService")
public class DefaultContentService
extends AbstractScmService
implements ContentService {
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final InternalUserService userService;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @Value(value="${content.archive.timeout}")
    private Duration archiveTimeout;
    @Value(value="${content.upload.max.size}")
    private long maxUploadSize;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @Value(value="${content.patch.timeout}")
    private Duration patchTimeout;

    @Autowired
    public DefaultContentService(InternalScmService scmService, AuthenticationContext authenticationContext, EventPublisher eventPublisher, I18nService i18nService, RefService refService, RepositoryService repositoryService, InternalUserService userService) {
        super(scmService);
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.userService = userService;
    }

    @PreAuthorize(value="hasRepositoryPermission(#request?.repository, 'REPO_WRITE')")
    public Commit editFile(@Nonnull EditFileRequest request) throws ServiceException {
        SimpleRefChange refChange;
        SimpleBranch updatedBranch;
        Repository repository = request.getRepository();
        this.checkRepositoryNotArchived(repository);
        if (!this.scmService.isSupported(repository, ScmFeature.EDIT_FILE)) {
            throw new FeatureUnsupportedScmException(this.i18nService.createKeyedMessage("bitbucket.service.repository.scm.nofileeditfeature", new Object[]{repository.getProject().getKey(), repository.getSlug(), this.scmService.getScmName(repository)}), repository.getScmId(), ScmFeature.EDIT_FILE);
        }
        boolean newBranchRequested = !request.getBranch().equals(request.getSourceBranch());
        Branch sourceBranch = (Branch)this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(request.getSourceBranch()).type((RefType)StandardRefType.BRANCH).build());
        if (sourceBranch == null && (newBranchRequested || !this.repositoryService.isEmpty(repository))) {
            throw new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branchnotfound", new Object[]{request.getSourceBranch(), repository}), request.getSourceBranch());
        }
        String commitMessage = request.getMessage().orElseGet(() -> this.i18nService.getMessage("bitbucket.service.repository.file.edit.message", new Object[]{Product.NAME}));
        ApplicationUser validCurrentUser = this.getValidCurrentUserForEditFile();
        EditFileCommandParameters parameters = new EditFileCommandParameters.Builder(sourceBranch, request.getPath()).author(this.getAuthor(request).orElse(validCurrentUser)).committer(validCurrentUser).content(request.getContent()).sourceCommitId((String)request.getSourceCommitId().orElse(null)).targetBranch(request.getBranch()).message(commitMessage).build();
        Commit commit = (Commit)this.scmService.getExtendedCommandFactory(repository).editFile(parameters).call();
        if (newBranchRequested || sourceBranch == null) {
            updatedBranch = (Branch)this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(request.getBranch()).type((RefType)StandardRefType.BRANCH).build());
            if (updatedBranch == null) {
                throw new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branchnotfound", new Object[]{request.getBranch(), repository}), request.getBranch());
            }
            refChange = ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().to((Ref)updatedBranch)).fromHash(ShaUtils.NULL_SHA1)).type(RefChangeType.ADD)).build();
        } else {
            updatedBranch = ((SimpleBranch.Builder)new SimpleBranch.Builder(sourceBranch).latestCommit(commit.getId())).build();
            refChange = ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().from((Ref)sourceBranch)).toHash(commit.getId())).type(RefChangeType.UPDATE)).build();
        }
        this.eventPublisher.publish((Object)new FileEditedEvent((Object)this, repository, (Branch)updatedBranch, (RefChange)refChange, request.getPath(), request.getContent(), commitMessage));
        return commit;
    }

    @Nonnull
    public Page<Blame> getBlame(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String path, @Nonnull PageRequest pageRequest) {
        Page blame = (Page)this.getCommandFactory(repository).blame(((BlameCommandParameters.Builder)((BlameCommandParameters.Builder)new BlameCommandParameters.Builder().commitId(commitId)).path(path)).build(), pageRequest).call();
        return blame == null ? PageUtils.createEmptyPage((PageRequest)pageRequest) : this.updateContributors((Page<Blame>)blame);
    }

    @PreAuthorize(value="permitAll()")
    @Unsecured(value="Anyone is allowed to check the maximum content upload size")
    public long getMaxUploadSize() {
        return this.maxUploadSize;
    }

    @Nonnull
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true, noRollbackFor={NoSuchObjectException.class})
    public OptionalLong getSize(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String path) {
        Objects.requireNonNull(commitId, "commitId");
        Objects.requireNonNull(path, "path");
        Long size = (Long)this.getCommandFactory(repository).size(((SizeCommandParameters.Builder)((SizeCommandParameters.Builder)new SizeCommandParameters.Builder().commitId(commitId)).path(path)).build()).call();
        return size == null ? OptionalLong.empty() : OptionalLong.of(size);
    }

    @Nonnull
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true, noRollbackFor={NoSuchPathException.class})
    public ContentTreeNode.Type getType(@Nonnull Repository repository, @Nonnull String commitId, String path) {
        Objects.requireNonNull(commitId, "commitId");
        ContentTreeNode.Type type = (ContentTreeNode.Type)this.getCommandFactory(repository).type(((TypeCommandParameters.Builder)((TypeCommandParameters.Builder)new TypeCommandParameters.Builder().commitId(commitId)).path(path)).build()).call();
        if (type == null) {
            throw new NoSuchPathException(this.i18nService.createKeyedMessage("bitbucket.service.repository.pathnotfound.atrevision", new Object[]{path, commitId}), path, commitId);
        }
        return type;
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    @Throttled(value="scm-hosting")
    public void streamArchive(@Nonnull ArchiveRequest request, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(outputSupplier, "outputSupplier");
        try {
            Command command = this.scmService.getExtendedCommandFactory(request.getRepository()).archive(new ArchiveCommandParameters.Builder(request).build(), outputSupplier);
            command.setTimeout(this.archiveTimeout);
            command.call();
            this.eventPublisher.publish((Object)new ContentArchiveSuccessfulEvent(this, request));
        }
        catch (Exception e) {
            this.eventPublisher.publish((Object)new ContentArchiveFailedEvent(this, request));
            throw e;
        }
    }

    public void streamDirectory(@Nonnull Repository repository, @Nonnull String objectId, String path, boolean recursive, @Nonnull ContentTreeCallback callback, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(recursive ? this.maxDirectoryRecursiveChildren : this.maxDirectoryChildren);
        DirectoryCommandParameters parameters = ((DirectoryCommandParameters.Builder)((DirectoryCommandParameters.Builder)new DirectoryCommandParameters.Builder().commitId(objectId)).path(path)).recurse(recursive).withSizes(!recursive).build();
        this.getCommandFactory(repository).directory(parameters, callback, pageRequest).call();
    }

    public void streamFile(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull PageRequest pageRequest, boolean withBlame, @Nonnull FileContentCallback callback) throws ServiceException {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxSourceLines);
        if (withBlame) {
            callback = new AuthorUpdatingFileContentCallback(callback);
        }
        FileCommandParameters parameters = ((FileCommandParameters.Builder)((FileCommandParameters.Builder)new FileCommandParameters.Builder().annotate(withBlame).commitId(objectId)).maxLineLength(this.maxLineLength).path(path)).build();
        this.getCommandFactory(repository).file(parameters, callback, pageRequest).call();
    }

    public void streamFile(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull TypeAwareOutputSupplier supplier) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)path) || "/".equals(path)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.content.raw.pathrequired", new Object[0]));
        }
        RawFileCommandParameters parameters = ((RawFileCommandParameters.Builder)((RawFileCommandParameters.Builder)new RawFileCommandParameters.Builder().commitId(objectId)).path(path)).build();
        this.getCommandFactory(repository).rawFile(parameters, supplier).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public void streamPatch(@Nonnull PatchRequest request, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(outputSupplier, "outputSupplier");
        Command command = this.scmService.getExtendedCommandFactory(request.getRepository()).patch(new PatchCommandParameters.Builder(request).build(), outputSupplier);
        command.setTimeout(this.patchTimeout);
        command.call();
    }

    private void checkRepositoryNotArchived(Repository repo) {
        if (repo.isArchived()) {
            throw new RepositoryArchivedException(this.i18nService.getKeyedText(new I18nKey("bitbucket.service.repository.file.edit.repoarchived", new Object[0])));
        }
    }

    private Optional<ApplicationUser> getAuthor(EditFileRequest request) {
        return request.getAuthor().map(author -> {
            if (author instanceof InternalServiceUser) {
                throw new ArgumentValidationException(this.i18nService.getKeyedText(new I18nKey("bitbucket.service.repository.file.edit.serviceuserasauthor", new Object[0])));
            }
            if (StringUtils.isBlank((CharSequence)author.getEmailAddress())) {
                throw new ArgumentValidationException(this.i18nService.getKeyedText(new I18nKey("bitbucket.service.repository.file.edit.blankauthoremail", new Object[0])));
            }
            return author;
        });
    }

    private ApplicationUser getValidCurrentUserForEditFile() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null || currentUser instanceof InternalServiceUser) {
            throw new ForbiddenException(this.i18nService.getKeyedText(new I18nKey("bitbucket.service.repository.file.edit.nouser", new Object[0])));
        }
        if (StringUtils.isBlank((CharSequence)currentUser.getEmailAddress())) {
            throw new ArgumentValidationException(this.i18nService.getKeyedText(new I18nKey("bitbucket.service.repository.file.edit.blankuseremail", new Object[0])));
        }
        return currentUser;
    }

    private Page<Blame> updateContributors(Page<Blame> blames) {
        if (blames.getSize() == 0) {
            return blames;
        }
        Set emailAddresses = (Set)blames.stream().flatMap(blame -> Stream.of(blame.getAuthor(), blame.getCommitter())).map(Person::getEmailAddress).filter(StringUtils::isNotBlank).collect(MoreCollectors.toImmutableSet());
        Map usersByEmail = this.userService.mapUsersByEmail(emailAddresses);
        if (usersByEmail.isEmpty()) {
            return blames;
        }
        return blames.transform(blame -> {
            ApplicationUser committer;
            SimpleBlame.Builder builder = null;
            ApplicationUser author = (ApplicationUser)usersByEmail.get(blame.getAuthor().getEmailAddress());
            if (author != null) {
                builder = new SimpleBlame.Builder(blame).author((Person)author);
            }
            if ((committer = (ApplicationUser)usersByEmail.get(blame.getCommitter().getEmailAddress())) != null) {
                if (builder == null) {
                    builder = new SimpleBlame.Builder(blame);
                }
                builder.committer((Person)committer);
            }
            return builder == null ? blame : builder.build();
        });
    }

    private class AuthorUpdatingFileContentCallback
    implements FileContentCallback {
        private final FileContentCallback delegate;

        AuthorUpdatingFileContentCallback(FileContentCallback callback) {
            this.delegate = callback;
        }

        public void offerBlame(@Nonnull Page<Blame> blames) throws IOException {
            this.delegate.offerBlame(DefaultContentService.this.updateContributors(blames));
        }

        public void onBinary() throws IOException {
            this.delegate.onBinary();
        }

        public void onEnd(@Nonnull FileSummary summary) throws IOException {
            this.delegate.onEnd(summary);
        }

        public boolean onLine(int lineNumber, String line, boolean truncated) throws IOException {
            return this.delegate.onLine(lineNumber, line, truncated);
        }

        public void onStart(@Nonnull FileContext context) throws IOException {
            this.delegate.onStart(context);
        }
    }
}

