/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.stash.internal.HomeLayout;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MimeTypeMappingConfiguration
implements FileNameMap {
    private static final String BINARY_TYPES_RESOURCE = "binary-mime.types";
    private static final String TEXT_TYPES_RESOURCE = "text-mime.types";
    private static final Logger log = LoggerFactory.getLogger(MimeTypeMappingConfiguration.class);
    private final Set<String> binaryTypes = new HashSet<String>();
    private final HomeLayout homeLayout;
    private final Map<String, String> mimeMap = new HashMap<String, String>();
    private final Set<String> textTypes = new HashSet<String>();
    private FileNameMap fallbackMap;

    @Autowired
    public MimeTypeMappingConfiguration(HomeLayout homeLayout) {
        this.homeLayout = homeLayout;
        this.fallbackMap = URLConnection.getFileNameMap();
    }

    @Override
    public String getContentTypeFor(String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (fileName.length() == idx + 1) {
            return null;
        }
        String ext = fileName.substring(idx + 1);
        if (this.mimeMap.containsKey(ext)) {
            return this.mimeMap.get(ext);
        }
        if (this.fallbackMap != null) {
            return this.fallbackMap.getContentTypeFor(fileName);
        }
        return null;
    }

    @PostConstruct
    public void init() {
        this.loadInternalConfig();
        this.loadMimeMaps(this.homeLayout.getConfigDir());
        URLConnection.setFileNameMap(this);
    }

    @VisibleForTesting
    void addTextMimeType(String mimeType) {
        this.textTypes.add(mimeType);
    }

    @VisibleForTesting
    void addBinaryMimeType(String mimeType) {
        this.binaryTypes.add(mimeType);
    }

    @VisibleForTesting
    void addExtensionMapping(String mimeType, String extension) {
        this.mimeMap.put(extension, mimeType);
    }

    @VisibleForTesting
    boolean isTextMimeType(String mimeType) {
        return mimeType != null && (mimeType.startsWith("text/") || this.textTypes.contains(mimeType));
    }

    @VisibleForTesting
    boolean isBinaryMimeType(String mimeType) {
        return mimeType != null && !mimeType.startsWith("text/") && this.binaryTypes.contains(mimeType);
    }

    private void loadInternalConfig() {
        ClassLoader loader = MimeTypeMappingConfiguration.class.getClassLoader();
        this.loadMimeMap(loader.getResourceAsStream(BINARY_TYPES_RESOURCE), false, BINARY_TYPES_RESOURCE);
        this.loadMimeMap(loader.getResourceAsStream(TEXT_TYPES_RESOURCE), true, TEXT_TYPES_RESOURCE);
    }

    private void loadMimeMaps(Path directory) {
        this.loadMimeMap(directory.resolve(BINARY_TYPES_RESOURCE), false);
        this.loadMimeMap(directory.resolve(TEXT_TYPES_RESOURCE), true);
    }

    private void loadMimeMap(Path mapFile, boolean textMap) {
        if (!Files.isRegularFile(mapFile, new LinkOption[0])) {
            return;
        }
        try (InputStream in = Files.newInputStream(mapFile, new OpenOption[0]);){
            this.loadMimeMap(in, textMap, mapFile.toString());
        }
        catch (IOException e) {
            log.warn("Error reading mime type mapping from " + String.valueOf(mapFile), (Throwable)e);
        }
    }

    private void loadMimeMap(InputStream mapStream, boolean textMap, String sourceName) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(mapStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                String mimeType;
                if ((line = line.trim()).startsWith("#") || line.length() == 0 || (mimeType = this.parseLine(line)) == null) continue;
                if (textMap) {
                    this.addTextMimeType(mimeType);
                    continue;
                }
                this.addBinaryMimeType(mimeType);
            }
        }
        catch (IOException e) {
            log.warn("Error reading mime type mapping from " + sourceName, (Throwable)e);
        }
    }

    private String parseLine(String line) {
        StringTokenizer tok = new StringTokenizer(line);
        String mimetype = null;
        if (tok.hasMoreTokens()) {
            mimetype = tok.nextToken();
            while (tok.hasMoreTokens()) {
                String ext = tok.nextToken();
                this.addExtensionMapping(mimetype, ext);
            }
        } else {
            log.warn("not a valid line in mime type file: {}", (Object)line);
        }
        return mimetype;
    }
}

