/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.bitbucket.dmz.crowd.CrowdEncryptionConfigurationException;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.crowd.crypto.Algorithm;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BitbucketEncryptionSettings
implements EncryptionSettings {
    private static final String KEYS_SUB_DIRECTORY = "keys";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String keyFilesDirectoryPath;
    private final InternalApplicationPropertiesService propertiesService;
    private final StorageService storageService;

    public BitbucketEncryptionSettings(StorageService storageService, InternalApplicationPropertiesService propertiesService) {
        this.storageService = storageService;
        this.propertiesService = propertiesService;
        this.keyFilesDirectoryPath = this.setKeyFilesDirectoryPath();
    }

    @Nonnull
    public Optional<String> getDefaultEncryptor() {
        return Optional.of(Algorithm.AES.getKey());
    }

    @Nonnull
    public Optional<String> getEncryptionKeyPath(@Nonnull String encryptor) {
        Objects.requireNonNull(encryptor, "encryptor");
        String keyPaths = this.propertiesService.getCrowdEncryptionKeyPath();
        if (keyPaths == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.unmarshallKeyPaths(keyPaths).get(encryptor));
    }

    @Nonnull
    public String getKeyFilesDirectoryPath() {
        return this.keyFilesDirectoryPath;
    }

    public void setDefaultEncryptor(@Nonnull String encryptor) {
        if (!Algorithm.AES.getKey().equals(encryptor)) {
            throw new UnsupportedOperationException("AES encryption is the only supported standard, cannot change default encryption.");
        }
    }

    public void setEncryptionKeyPath(@Nonnull String encryptor, @Nonnull String keyPath) {
        Objects.requireNonNull(encryptor, "encryptor");
        Objects.requireNonNull(keyPath, "keyPath");
        Map<String, String> keyPathMap = this.unmarshallKeyPaths(this.propertiesService.getCrowdEncryptionKeyPath());
        keyPathMap.compute(encryptor, (key, value) -> keyPath);
        this.propertiesService.setCrowdEncryptionKeyPath(this.marshalKeyPaths(keyPathMap));
    }

    private String marshalKeyPaths(Map<String, String> keyPathMap) {
        try {
            return MAPPER.writeValueAsString(keyPathMap);
        }
        catch (JsonProcessingException e) {
            throw new CrowdEncryptionConfigurationException("Error marshalling key path map", (Throwable)e);
        }
    }

    private String setKeyFilesDirectoryPath() {
        Path sharedHome = this.storageService.getSharedHomeDir();
        String keyPath = sharedHome.resolve(KEYS_SUB_DIRECTORY).toString();
        this.validateKeysDirectory(new File(keyPath));
        return keyPath;
    }

    private Map<String, String> unmarshallKeyPaths(String rawKeyPaths) {
        if (rawKeyPaths == null) {
            return new HashMap<String, String>();
        }
        try {
            return new HashMap<String, String>((Map)MAPPER.readValue(rawKeyPaths, (TypeReference)new TypeReference<Map<String, String>>(this){}));
        }
        catch (JsonProcessingException e) {
            throw new CrowdEncryptionConfigurationException("Error parsing encryption key paths", (Throwable)e);
        }
    }

    private void validateKeysDirectory(File keyFilesDirectoryPath) {
        if (!keyFilesDirectoryPath.exists()) {
            if (!keyFilesDirectoryPath.mkdirs()) {
                throw new CrowdEncryptionConfigurationException("Unable to create encryption keys directory, verify filesystem permissions.");
            }
        } else if (!keyFilesDirectoryPath.isDirectory()) {
            throw new CrowdEncryptionConfigurationException("Unable to create encryption keys directory, file with the same name already exists.");
        }
        try {
            MoreFiles.setSafeDirectoryPermissions((Path)keyFilesDirectoryPath.toPath());
        }
        catch (IOException e) {
            throw new CrowdEncryptionConfigurationException("Error setting permissions for encryption keys directory", (Throwable)e);
        }
    }
}

