/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.crypto.Algorithm;
import com.atlassian.crowd.crypto.DbConfigPasswordCipherEncryptorsFactory;
import com.atlassian.crowd.crypto.PrefixBasedSwitchableEncryptor;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;

public class BitbucketEncryptorFactory {
    private final boolean encryptionEnabled;
    private final EncryptionSettings encryptionSettings;

    public BitbucketEncryptorFactory(EncryptionSettings encryptionSettings, boolean encryptionEnabled) {
        this.encryptionSettings = encryptionSettings;
        this.encryptionEnabled = encryptionEnabled;
    }

    @Nonnull
    public Encryptor getEncryptor() {
        if (this.encryptionEnabled) {
            Map supportedEncryptors = DbConfigPasswordCipherEncryptorsFactory.createEncryptorsMap((EncryptionSettings)this.encryptionSettings);
            ImmutableMap securedEncryptors = ImmutableMap.of((Object)Algorithm.AES.getKey(), (Object)((Encryptor)supportedEncryptors.get(Algorithm.AES.getKey())));
            return new PrefixBasedSwitchableEncryptor(this.encryptionSettings, (Map)securedEncryptors);
        }
        return new NoopEncryptor();
    }

    static class NoopEncryptor
    implements Encryptor {
        NoopEncryptor() {
        }

        public String decrypt(String encryptedPassword) {
            return encryptedPassword;
        }

        public String encrypt(String password) {
            return password;
        }
    }
}

