/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.bitbucket.dmz.crowd.BitbucketResourceType;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectSearchRequest;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySearchRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.crowd.embedded.api.Page;
import com.atlassian.crowd.embedded.api.service.Resource;
import com.atlassian.crowd.embedded.spi.service.ResourceDescription;
import com.atlassian.crowd.embedded.spi.service.ResourceTypeDescription;
import com.atlassian.crowd.embedded.spi.service.RestrictedResourcesProvider;
import com.atlassian.crowd.search.PageImpl;
import com.atlassian.stash.internal.crowd.SimpleResource;
import com.atlassian.stash.internal.crowd.SimpleResourceDescription;
import com.atlassian.stash.internal.crowd.SimpleResourceTypeDescription;
import jakarta.annotation.Nonnull;
import java.util.List;

public class BitbucketRestrictedResourcesProvider
implements RestrictedResourcesProvider {
    private final ProjectService projectService;
    private final RepositoryService repositoryService;

    public BitbucketRestrictedResourcesProvider(ProjectService projectService, RepositoryService repositoryService) {
        this.projectService = projectService;
        this.repositoryService = repositoryService;
    }

    @Nonnull
    public Page<? extends ResourceDescription> findResources(String resourceTypeId, String searchText, com.atlassian.crowd.embedded.api.PageRequest pageRequest) {
        BitbucketResourceType bitbucketResourceType = BitbucketResourceType.fromId((String)resourceTypeId);
        if (bitbucketResourceType == null) {
            throw new IllegalArgumentException("Invalid resource type: " + resourceTypeId);
        }
        PageRequest pageRequestImpl = PageUtils.newRequest((int)pageRequest.start(), (int)pageRequest.limit());
        return switch (bitbucketResourceType) {
            default -> throw new MatchException(null, null);
            case BitbucketResourceType.PROJECT -> {
                ProjectSearchRequest.Builder builder = new ProjectSearchRequest.Builder().name(searchText);
                com.atlassian.bitbucket.util.Page projectPage = this.projectService.search(builder.build(), pageRequestImpl);
                List<ResourceDescription> resources = projectPage.stream().map(BitbucketRestrictedResourcesProvider::asResourceDescription).toList();
                yield new PageImpl(resources, projectPage.getStart(), projectPage.getLimit(), projectPage.getSize(), projectPage.getIsLastPage());
            }
            case BitbucketResourceType.REPOSITORY -> {
                RepositorySearchRequest.Builder builder = new RepositorySearchRequest.Builder().name(searchText);
                com.atlassian.bitbucket.util.Page repositoryPage = this.repositoryService.search(builder.build(), pageRequestImpl);
                List<ResourceDescription> resources = repositoryPage.stream().map(BitbucketRestrictedResourcesProvider::asResourceDescription).toList();
                yield new PageImpl(resources, repositoryPage.getStart(), repositoryPage.getLimit(), repositoryPage.getSize(), repositoryPage.getIsLastPage());
            }
        };
    }

    @Nonnull
    public List<? extends ResourceTypeDescription> getAllResourceTypes() {
        return BitbucketResourceType.getAllResourceTypes().stream().map(SimpleResourceTypeDescription::new).toList();
    }

    public ResourceDescription getResource(String resourceTypeId, String resourceId) {
        BitbucketResourceType bitbucketResourceType = BitbucketResourceType.fromId((String)resourceTypeId);
        if (bitbucketResourceType == null) {
            throw new IllegalArgumentException("Invalid resourceTypeId: " + resourceTypeId);
        }
        return switch (bitbucketResourceType) {
            default -> throw new MatchException(null, null);
            case BitbucketResourceType.PROJECT -> {
                Project project = this.projectService.getById(Integer.parseInt(resourceId));
                if (project == null) {
                    yield null;
                }
                yield BitbucketRestrictedResourcesProvider.asResourceDescription(project);
            }
            case BitbucketResourceType.REPOSITORY -> {
                Repository repository = this.repositoryService.getById(Integer.parseInt(resourceId));
                if (repository == null) {
                    yield null;
                }
                yield BitbucketRestrictedResourcesProvider.asResourceDescription(repository);
            }
        };
    }

    public List<ResourceDescription> getResources(List<Resource> resources) {
        return resources.stream().map(resource -> this.getResource(resource.getTypeId(), resource.getId())).toList();
    }

    private static ResourceDescription asResourceDescription(Project project) {
        return new SimpleResourceDescription(new SimpleResource(project.getId(), BitbucketResourceType.PROJECT), project.getName());
    }

    private static ResourceDescription asResourceDescription(Repository repository) {
        return new SimpleResourceDescription(new SimpleResource(repository.getId(), BitbucketResourceType.REPOSITORY), repository.getName());
    }
}

