/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.ServiceUserUpdateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.crowd.dao.service.ServiceAccountManagerDAO;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.manager.service.ServiceAccountManagerImpl;

public class BitbucketServiceAccountManager
extends ServiceAccountManagerImpl {
    private static final String SERVICE_ACCOUNT_LABEL = "service-account";
    public static final String SERVICE_ACCOUNT_NAME_PREFIX = "service-account_";
    private final UserAdminService userAdminService;
    private final UserService userService;

    public BitbucketServiceAccountManager(ServiceAccountManagerDAO serviceAccountManagerDao, UserAdminService userAdminService, UserService userService) {
        super(serviceAccountManagerDao);
        this.userAdminService = userAdminService;
        this.userService = userService;
    }

    public ServiceAccount createServiceAccount(ServiceAccount serviceAccount) {
        ServiceAccount newServiceAccount = super.createServiceAccount(serviceAccount);
        this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().active(serviceAccount.isActive())).name(SERVICE_ACCOUNT_NAME_PREFIX + newServiceAccount.getId())).displayName(serviceAccount.getDisplayName())).label(SERVICE_ACCOUNT_LABEL)).build());
        return newServiceAccount;
    }

    public boolean updateServiceAccount(ServiceAccount serviceAccount) {
        ServiceUser serviceUser = this.userService.getServiceUserByName(SERVICE_ACCOUNT_NAME_PREFIX + serviceAccount.getId());
        if (serviceUser != null) {
            this.userAdminService.updateServiceUser(((ServiceUserUpdateRequest.Builder)((ServiceUserUpdateRequest.Builder)((ServiceUserUpdateRequest.Builder)new ServiceUserUpdateRequest.Builder(serviceUser.getId()).active(serviceAccount.isActive())).displayName(serviceAccount.getDisplayName())).label(SERVICE_ACCOUNT_LABEL)).build());
        }
        return super.updateServiceAccount(serviceAccount);
    }
}

