/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.directory.AzureAdDirectory;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.cache.DeltaQueryCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresherFactory;
import com.atlassian.crowd.directory.ldap.cache.EventTokenChangedCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.RemoteDirectoryCacheRefresher;
import com.atlassian.crowd.directory.synchronisation.cache.CacheRefresher;
import com.atlassian.stash.internal.crowd.CustomizedUsnChangedCacheRefresher;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRefresherFactoryImpl
implements CacheRefresherFactory {
    private static final Logger log = LoggerFactory.getLogger(CacheRefresherFactoryImpl.class);
    private final SessionFactory sessionFactory;

    public CacheRefresherFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public CacheRefresher createRefresher(RemoteDirectory remoteDirectory) {
        if (remoteDirectory instanceof MicrosoftActiveDirectory) {
            return new CustomizedUsnChangedCacheRefresher((MicrosoftActiveDirectory)remoteDirectory, this.sessionFactory);
        }
        if (remoteDirectory instanceof RemoteCrowdDirectory) {
            RemoteDirectoryCacheRefresher fullSyncCacheRefresher = new RemoteDirectoryCacheRefresher(remoteDirectory);
            return new EventTokenChangedCacheRefresher((RemoteCrowdDirectory)remoteDirectory, (CacheRefresher)fullSyncCacheRefresher);
        }
        if (remoteDirectory instanceof AzureAdDirectory) {
            if (((AzureAdDirectory)remoteDirectory).supportsDeltaQueryApi()) {
                return new DeltaQueryCacheRefresher((AzureAdDirectory)remoteDirectory);
            }
            if (log.isDebugEnabled()) {
                log.debug("Got an Azure AD directory with ID {}, which doesn't support Delta Query API, returning the non-incremental synchronizer", (Object)remoteDirectory.getDirectoryId());
            }
            return new RemoteDirectoryCacheRefresher(remoteDirectory);
        }
        return new RemoteDirectoryCacheRefresher(remoteDirectory);
    }
}

