/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordPolicyConfiguration;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.validator.DirectoryValidationContext;
import com.atlassian.crowd.validator.ValidationError;
import java.util.EnumSet;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class CustomizedCrowdDirectoryService
implements CrowdDirectoryService {
    private final CrowdDirectoryService crowdDirectoryService;
    private final ApplicationManager applicationManager;
    private final ApplicationFactory applicationFactory;

    public CustomizedCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService, ApplicationManager applicationManager, ApplicationFactory applicationFactory) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.applicationFactory = applicationFactory;
        this.applicationManager = applicationManager;
    }

    @Transactional
    public Directory addDirectory(Directory directory) throws OperationFailedException {
        Directory addedDirectory = this.crowdDirectoryService.addDirectory(directory);
        try {
            this.applicationManager.addDirectoryMapping(this.applicationFactory.getApplication(), addedDirectory, true, OperationType.values());
        }
        catch (ApplicationNotFoundException | DirectoryNotFoundException e) {
            throw new OperationFailedException(e);
        }
        return addedDirectory;
    }

    public void testConnection(Directory directory) throws OperationFailedException {
        this.crowdDirectoryService.testConnection(directory);
    }

    public List<Directory> findAllDirectories() {
        return this.crowdDirectoryService.findAllDirectories().stream().map(directory -> this.findDirectoryById(directory.getId())).toList();
    }

    public Directory findDirectoryById(long directoryId) {
        return this.crowdDirectoryService.findDirectoryById(directoryId);
    }

    public Directory findDirectoryByName(String name) {
        return this.crowdDirectoryService.findDirectoryByName(name);
    }

    public Directory updateDirectory(Directory directory) throws OperationFailedException {
        return this.crowdDirectoryService.updateDirectory(directory);
    }

    public void setDirectoryPosition(long directoryId, int position) throws OperationFailedException {
        this.crowdDirectoryService.setDirectoryPosition(directoryId, position);
    }

    @Transactional
    public boolean removeDirectory(long directoryId) throws DirectoryCurrentlySynchronisingException, OperationFailedException {
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        if (directory != null) {
            try {
                this.applicationManager.removeDirectoryFromApplication(directory, this.applicationFactory.getApplication());
            }
            catch (ApplicationManagerException e) {
                throw new OperationFailedException((Throwable)e);
            }
            return this.crowdDirectoryService.removeDirectory(directoryId);
        }
        return false;
    }

    public boolean supportsNestedGroups(long directoryId) throws OperationFailedException {
        return this.crowdDirectoryService.supportsNestedGroups(directoryId);
    }

    public boolean isDirectorySynchronisable(long directoryId) throws OperationFailedException {
        return this.crowdDirectoryService.isDirectorySynchronisable(directoryId);
    }

    public void synchroniseDirectory(long directoryId) throws OperationFailedException {
        this.crowdDirectoryService.synchroniseDirectory(directoryId);
    }

    public void synchroniseDirectory(long directoryId, boolean runInBackground) throws OperationFailedException {
        this.crowdDirectoryService.synchroniseDirectory(directoryId, runInBackground);
    }

    public boolean isDirectorySynchronising(long directoryId) throws OperationFailedException {
        return this.crowdDirectoryService.isDirectorySynchronising(directoryId);
    }

    public DirectorySynchronisationInformation getDirectorySynchronisationInformation(long directoryId) throws OperationFailedException {
        return this.crowdDirectoryService.getDirectorySynchronisationInformation(directoryId);
    }

    public void setConnectionPoolProperties(ConnectionPoolProperties poolProperties) {
        this.crowdDirectoryService.setConnectionPoolProperties(poolProperties);
    }

    public ConnectionPoolProperties getStoredConnectionPoolProperties() {
        return this.crowdDirectoryService.getStoredConnectionPoolProperties();
    }

    public ConnectionPoolProperties getSystemConnectionPoolProperties() {
        return this.crowdDirectoryService.getSystemConnectionPoolProperties();
    }

    public boolean isMembershipAggregationEnabled() {
        return this.crowdDirectoryService.isMembershipAggregationEnabled();
    }

    public void setMembershipAggregationEnabled(boolean enabled) {
        this.crowdDirectoryService.setMembershipAggregationEnabled(enabled);
    }

    public PasswordPolicyConfiguration getPasswordPolicyConfiguration(long directoryId) throws OperationNotSupportedException, DirectoryNotFoundException {
        return this.crowdDirectoryService.getPasswordPolicyConfiguration(directoryId);
    }

    public void setPasswordPolicyConfiguration(long directoryId, PasswordPolicyConfiguration passwordPolicyConfiguration, String passwordComplexityMessage) throws OperationNotSupportedException, DirectoryNotFoundException {
        this.crowdDirectoryService.setPasswordPolicyConfiguration(directoryId, passwordPolicyConfiguration, passwordComplexityMessage);
    }

    public String getPasswordComplexityMessage(long directoryId) throws OperationNotSupportedException, DirectoryNotFoundException {
        return this.crowdDirectoryService.getPasswordComplexityMessage(directoryId);
    }

    public void initJndiLdapConnectionPool() {
        this.crowdDirectoryService.initJndiLdapConnectionPool();
    }

    public List<ValidationError> validateDirectoryConfiguration(Directory directory, EnumSet<DirectoryValidationContext> validationContexts) {
        return this.crowdDirectoryService.validateDirectoryConfiguration(directory, validationContexts);
    }
}

