/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.synchronisation.CacheSynchronisationResult;
import com.atlassian.crowd.directory.synchronisation.cache.DirectoryCache;
import com.atlassian.crowd.directory.synchronisation.cache.UsnChangedCacheRefresher;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.hibernate.SessionFactory;

@NotThreadSafe
public class CustomizedUsnChangedCacheRefresher
extends UsnChangedCacheRefresher {
    private final SessionFactory sessionFactory;
    private final Set<LDAPGroupWithAttributes> syncedGroups = new HashSet<LDAPGroupWithAttributes>();

    public CustomizedUsnChangedCacheRefresher(@Nonnull MicrosoftActiveDirectory activeDirectory, @Nonnull SessionFactory sessionFactory) {
        super(activeDirectory);
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheSynchronisationResult synchroniseChanges(@Nonnull DirectoryCache directoryCache, @Nullable String highestCommittedUsn) throws OperationFailedException {
        try {
            CacheSynchronisationResult cacheSynchronisationResult = super.synchroniseChanges(directoryCache, highestCommittedUsn);
            return cacheSynchronisationResult;
        }
        finally {
            this.syncedGroups.clear();
        }
    }

    protected void synchroniseMemberships(@Nonnull Collection<LDAPGroupWithAttributes> remoteGroups, @Nonnull DirectoryCache directoryCache, boolean isFullSync) throws OperationFailedException {
        Sets.SetView reappearingGroups = Sets.intersection(new HashSet<LDAPGroupWithAttributes>(remoteGroups), this.syncedGroups);
        if (!reappearingGroups.isEmpty()) {
            this.refreshGroupMembershipQueryCache();
        }
        super.synchroniseMemberships(remoteGroups, directoryCache, isFullSync);
        this.syncedGroups.addAll(remoteGroups);
    }

    private void refreshGroupMembershipQueryCache() {
        this.sessionFactory.getCache().evictQueryRegion("query.groupMemberships");
    }
}

