/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.tombstone.TombstoneDao;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.crowd.InternalTombstoneCleanupService;
import java.time.Clock;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class DefaultTombstoneCleanupService
implements InternalTombstoneCleanupService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTombstoneCleanupService.class);
    private final Clock clock;
    private final long tombstoneCleanupJobDelay;
    private final TombstoneDao tombstoneDao;

    @Autowired
    public DefaultTombstoneCleanupService(Clock clock, @Value(value="${user.cleanup.job.delay:10080}") long tombstoneCleanupJobDelay, TombstoneDao tombstoneDao) {
        this.clock = clock;
        this.tombstoneCleanupJobDelay = tombstoneCleanupJobDelay;
        this.tombstoneDao = tombstoneDao;
    }

    @Override
    @Unsecured(value="Internal use only")
    public void cleanupExpiredTombstones() {
        log.debug("Cleaning up expired Crowd tombstone records");
        try {
            long cutoffTimeMillis = this.clock.instant().minus(Duration.ofMinutes(this.tombstoneCleanupJobDelay)).toEpochMilli();
            int deletedRecordCount = this.tombstoneDao.removeAllUpTo(cutoffTimeMillis);
            if (deletedRecordCount > 0) {
                log.info("Deleted {} expired Crowd tombstone records", (Object)deletedRecordCount);
            }
        }
        catch (DataAccessException e) {
            log.warn("Failed to clean up expired Crowd tombstone records", (Throwable)e);
            throw new DataAccessException("Crowd tombstone cleanup failed", e){};
        }
    }
}

