/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class Filter<T> {
    private final CrowdService crowdService;

    Filter(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    abstract Query<T> getQuery(String var1, int var2, int var3);

    abstract boolean isMatch(T var1);

    Page<T> scan(@Nonnull PageRequest pageRequest, String entity) {
        int limit = pageRequest.getLimit() + 1;
        int start = pageRequest.getStart();
        List results = this.search(this.getQuery(entity, 0, -1)).filter(this::isMatch).skip(start).limit(limit).collect(Collectors.toList());
        return PageUtils.createPage(results, (PageRequest)pageRequest);
    }

    private Stream<T> search(Query<T> query) {
        try (Timer ignored = TimerUtils.start((String)this.timerName(query));){
            Stream stream = MoreStreams.streamIterable((Iterable)this.crowdService.search(query));
            return stream;
        }
    }

    private String timerName(Query<T> query) {
        return this.getClass().getSimpleName() + ".search(" + query.getClass().getSimpleName() + ")";
    }
}

