/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.stash.internal.crowd.CredentialCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component(value="credentialCache")
@ConditionalOnExpression(value="${auth.cache.ttl} > 0")
public class GuavaCredentialCache
implements CredentialCache {
    private static final long MAX_TTL = 300L;
    private static final Logger log = LoggerFactory.getLogger(GuavaCredentialCache.class);
    private final Cache<String, CachedUser> cache;
    private final DirectoryManager directoryManager;

    @Autowired
    public GuavaCredentialCache(DirectoryManager directoryManager, @Value(value="${auth.cache.concurrency:10}") int concurrency, @Value(value="${auth.cache.tti}") long tti, @Value(value="${auth.cache.ttl}") long ttl) {
        if (ttl > 300L) {
            log.warn("{} seconds is the maximum TTL allowed when caching credentials, for security reasons. The configured TTL ({}) will be reduced to {}.", new Object[]{300L, ttl, 300L});
            ttl = 300L;
        }
        if (tti > ttl || tti < 1L) {
            tti = ttl;
        }
        this.directoryManager = directoryManager;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(concurrency).expireAfterAccess(tti, TimeUnit.SECONDS).expireAfterWrite(ttl, TimeUnit.SECONDS).build();
    }

    @Override
    public User get(@Nonnull String credentials) {
        Objects.requireNonNull(credentials, "credentials");
        CachedUser cached = (CachedUser)this.cache.getIfPresent((Object)credentials);
        if (cached == null) {
            return null;
        }
        try {
            com.atlassian.crowd.model.user.User user = this.directoryManager.findUserByName(cached.directoryId, cached.username);
            if (user.isActive()) {
                return user;
            }
        }
        catch (DirectoryNotFoundException | UserNotFoundException e) {
            log.info("{} will be re-authenticated; the associated Crowd user was not found", (Object)cached.username, (Object)(log.isDebugEnabled() ? e : null));
        }
        catch (CrowdException | CrowdRuntimeException e) {
            log.warn("{} will be re-authenticated; retrieving user details failed", (Object)cached.username, (Object)e);
        }
        return null;
    }

    @Override
    public void put(@Nonnull String credentials, @Nonnull User user) {
        Objects.requireNonNull(credentials, "credentials");
        Objects.requireNonNull(user, "user");
        this.cache.put((Object)credentials, (Object)new CachedUser(user));
    }

    @Override
    public void remove(@Nonnull String credentials) {
        Objects.requireNonNull(credentials, "credentials");
        this.cache.invalidate((Object)credentials);
    }

    private static class CachedUser {
        private final long directoryId;
        private final String username;

        public CachedUser(User user) {
            this.directoryId = user.getDirectoryId();
            this.username = user.getName();
        }
    }
}

