/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.model.application.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoizingApplicationFactory
implements ApplicationFactory {
    private static final Logger log = LoggerFactory.getLogger(MemoizingApplicationFactory.class);
    private ApplicationDAO applicationDao;
    private volatile Long applicationId;

    public Application getApplication() {
        Application application = null;
        try {
            if (this.applicationId == null) {
                application = this.applicationDao.findByName("crowd-embedded");
                this.applicationId = application.getId();
            } else {
                application = this.applicationDao.findById(this.applicationId.longValue());
            }
        }
        catch (ApplicationNotFoundException e) {
            log.debug("Crowd application : {} not found.", (Object)"crowd-embedded");
        }
        return application;
    }

    public String getApplicationName() {
        return "crowd-embedded";
    }

    public boolean isEmbeddedCrowd() {
        return true;
    }

    public void setApplicationDao(ApplicationDAO applicationDao) {
        this.applicationDao = applicationDao;
    }
}

