/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationSystemException;
import com.atlassian.bitbucket.auth.ExpiredPasswordAuthenticationException;
import com.atlassian.bitbucket.auth.InactiveUserAuthenticationException;
import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchGroupException;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserCapabilities;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.AccountNotFoundException;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.crowd.exception.runtime.GroupNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyImpl;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.GroupMembershipQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.query.membership.UserMembersOfGroupQuery;
import com.atlassian.stash.internal.crowd.CredentialCache;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.crowd.CrowdUserSearchRequest;
import com.atlassian.stash.internal.crowd.GroupMatchingFilter;
import com.atlassian.stash.internal.crowd.UserMatchingFilter;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.ConcurrentOperationMap;
import io.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="crowdControl")
public class RiotPolice
implements CrowdControl {
    public static final PropertyRestriction<Boolean> ACTIVE_USERS_ONLY = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true);
    private static final Logger log = LoggerFactory.getLogger(RiotPolice.class);
    private final ApplicationService applicationService;
    private final ApplicationFactory applicationFactory;
    private final AuthenticationContext authenticationContext;
    private final ConcurrentOperationMap<String, User> authenticationMap;
    private final CredentialCache credentialCache;
    private final CrowdService crowdService;
    private final DirectoryManager directoryManager;
    private final CrowdDirectoryService directoryService;
    private final I18nService i18nService;

    @Autowired
    public RiotPolice(ApplicationFactory applicationFactory, ApplicationService applicationService, AuthenticationContext authenticationContext, CredentialCache credentialCache, CrowdService crowdService, DirectoryManager directoryManager, CrowdDirectoryService directoryService, I18nService i18nService) {
        this.applicationFactory = applicationFactory;
        this.applicationService = applicationService;
        this.authenticationContext = authenticationContext;
        this.credentialCache = credentialCache;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        this.directoryService = directoryService;
        this.i18nService = i18nService;
        this.authenticationMap = new ConcurrentOperationMapImpl();
    }

    public void addGroupMember(@Nonnull Group group, @Nonnull User user) {
        Objects.requireNonNull(group, "group");
        Objects.requireNonNull(user, "user");
        this.execute(crowdService -> {
            try {
                crowdService.addUserToGroup(user, group);
            }
            catch (OperationNotPermittedException e) {
                log.warn("Could not add " + user.getName() + " to " + group.getName(), (Throwable)e);
                throw new AuthenticationSystemException(this.i18nService.createKeyedMessage("bitbucket.service.addmember.notpermitted", new Object[]{user.getName(), group.getName()}));
            }
        });
    }

    @Nonnull
    public User authenticate(@Nonnull String username, @Nonnull String password) {
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(password, "password");
        try {
            String hashedCredentials = RiotPolice.hashCredentials(username, password);
            return (User)this.authenticationMap.runOperation((Object)hashedCredentials, () -> {
                User user = this.credentialCache.get(hashedCredentials);
                if (user == null) {
                    user = this.doAuthenticate(username, password);
                    this.credentialCache.put(hashedCredentials, user);
                }
                return user;
            });
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public boolean canResetPassword(@Nonnull String username) {
        Objects.requireNonNull(username, "username");
        User user = this.findUser(username, false);
        if (user != null) {
            Directory directory = this.findDirectoryFor(user);
            return directory != null && directory.getType() == DirectoryType.INTERNAL;
        }
        return false;
    }

    public void checkPassword(@Nonnull String username, @Nonnull String password) {
        try {
            this.doAuthenticate(Objects.requireNonNull(username, "username"), Objects.requireNonNull(password, "password"));
        }
        catch (IncorrectPasswordAuthenticationException e) {
            throw new IncorrectPasswordAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.service.user.password.invalid", new Object[0]));
        }
    }

    @Nonnull
    public Group createGroup(@Nonnull Group group) {
        Objects.requireNonNull(group, "group");
        return this.execute(crowdService -> {
            try {
                return crowdService.addGroup(group);
            }
            catch (InvalidGroupException e) {
                throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.group.alreadyexists", new Object[]{group.getName()}));
            }
        });
    }

    @Nonnull
    public User createUser(@Nonnull User user, @Nonnull String password) {
        Objects.requireNonNull(user, "user");
        Preconditions.checkArgument((!Objects.requireNonNull(password, "password").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        return (User)this.execute(crowdService -> {
            try {
                return crowdService.addUser((UserWithAttributes)UserTemplateWithAttributes.toUserWithNoAttributes((User)user), password);
            }
            catch (InvalidUserException e) {
                throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.user.alreadyexists", new Object[]{user.getName()}));
            }
        });
    }

    public boolean deleteGroup(@Nonnull Group group) {
        Objects.requireNonNull(group, "group");
        return this.execute(crowdService -> {
            try {
                return crowdService.removeGroup(group);
            }
            catch (OperationNotPermittedException e) {
                log.warn("Group " + group.getName() + " could not be deleted", (Throwable)e);
                throw new AuthenticationSystemException(this.i18nService.createKeyedMessage("bitbucket.service.group.notdeletable", new Object[]{group.getName()}));
            }
        });
    }

    public boolean deleteUser(@Nonnull User user) {
        Objects.requireNonNull(user, "user");
        return this.execute(crowdService -> {
            try {
                return crowdService.removeUser(user);
            }
            catch (OperationNotPermittedException e) {
                log.warn("User " + user.getName() + " could not be deleted", (Throwable)e);
                throw new AuthenticationSystemException(this.i18nService.createKeyedMessage("bitbucket.service.user.notdeletable", new Object[]{user.getName()}));
            }
        });
    }

    public Directory findDirectoryFor(@Nonnull User user) {
        return this.directoryService.findDirectoryById(Objects.requireNonNull(user, "user").getDirectoryId());
    }

    public Group findGroup(@Nonnull String groupName) {
        return this.crowdService.getGroup(Objects.requireNonNull(groupName, "groupName"));
    }

    @Nonnull
    public Page<String> findGroups(@Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        GroupQuery query = new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, pageRequest.getStart(), pageRequest.getLimit() + 1);
        return this.getQueryPage((Query)query, pageRequest);
    }

    @Nonnull
    public Page<String> findGroupsByName(String groupName, @Nonnull PageRequest pageRequest) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            return this.findGroups(pageRequest);
        }
        Objects.requireNonNull(pageRequest, "pageRequest");
        return new GroupMatchingFilter(this, this.crowdService, groupName){

            @Override
            Query<String> getQuery(String filter, int offset, int limit) {
                PropertyRestriction restriction = Restriction.on((Property)GroupTermKeys.NAME).containing((Object)filter);
                return new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)restriction, offset, limit);
            }
        }.scan(pageRequest, groupName);
    }

    @Nonnull
    public Page<String> findGroupsByPrefix(@Nullable String groupPrefix, @Nonnull PageRequest pageRequest) {
        if (StringUtils.isBlank((CharSequence)groupPrefix)) {
            return this.findGroups(pageRequest);
        }
        Objects.requireNonNull(pageRequest, "pageRequest");
        GroupQuery query = new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)groupPrefix), pageRequest.getStart(), pageRequest.getLimit() + 1);
        return this.getQueryPage((Query)query, pageRequest);
    }

    @Nonnull
    public Page<String> findGroupsByUser(final @Nonnull String username, String groupName, boolean invert, @Nonnull PageRequest pageRequest) {
        GroupMatchingFilter filter;
        Objects.requireNonNull(pageRequest, "pageRequest");
        Objects.requireNonNull(username, "username");
        if (invert) {
            final User user = this.findUser(username, true);
            if (user == null) {
                return PageUtils.createEmptyPage((PageRequest)pageRequest);
            }
            final boolean emptyFilter = StringUtils.isBlank((CharSequence)groupName);
            filter = new GroupMatchingFilter(this.crowdService, groupName){

                @Override
                boolean isMatch(String groupName) {
                    return super.isMatch(groupName) && !RiotPolice.this.isGroupMember(groupName, user);
                }

                @Override
                Query<String> getQuery(String groupName, int offset, int limit) {
                    NullRestriction restriction = emptyFilter ? NullRestrictionImpl.INSTANCE : Restriction.on((Property)GroupTermKeys.NAME).containing((Object)groupName);
                    return new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)restriction, offset, limit);
                }
            };
        } else {
            filter = new GroupMatchingFilter(this, this.crowdService, groupName){

                @Override
                Query<String> getQuery(String groupName, int offset, int limit) {
                    return new GroupMembershipQuery(String.class, false, EntityDescriptor.user(), EntityDescriptor.group(), offset, limit, (SearchRestriction)NullRestrictionImpl.INSTANCE, new String[]{username});
                }
            };
        }
        return filter.scan(pageRequest, groupName);
    }

    public User findUser(@Nonnull String username, boolean inactive) {
        Objects.requireNonNull(username, "username");
        User user = this.crowdService.getUser(username);
        return user != null && (inactive || user.isActive()) ? user : null;
    }

    @Nullable
    public <T> User findUserByProperty(Property<T> property, T value) {
        return (User)Iterables.getFirst((Iterable)this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{ACTIVE_USERS_ONLY, Restriction.on(property).exactlyMatching(value)})).returningAtMost(1)), null);
    }

    @Nonnull
    public Page<User> findUsers(@Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        UserQuery query = new UserQuery(User.class, ACTIVE_USERS_ONLY, pageRequest.getStart(), pageRequest.getLimit() + 1);
        return this.getQueryPage((Query)query, pageRequest);
    }

    @Nonnull
    public Page<User> findUsersByGroup(final @Nonnull String groupName, String username, boolean invert, @Nonnull PageRequest pageRequest) {
        UserMatchingFilter filter;
        Objects.requireNonNull(groupName, "groupName");
        Objects.requireNonNull(pageRequest, "pageRequest");
        if (invert) {
            final boolean emptyFilter = StringUtils.isBlank((CharSequence)username);
            filter = new UserMatchingFilter(this.crowdService, username){

                @Override
                boolean isMatch(User candidate) {
                    return super.isMatch(candidate) && !RiotPolice.this.isGroupMember(groupName, candidate);
                }

                @Override
                Query<User> getQuery(String username, int offset, int limit) {
                    BooleanRestriction restriction = ACTIVE_USERS_ONLY;
                    if (!emptyFilter) {
                        restriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{restriction, Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)username), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)username), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)username)})});
                    }
                    return new UserQuery(User.class, restriction, offset, limit);
                }
            };
        } else {
            filter = new UserMatchingFilter(this, this.crowdService, username){

                @Override
                boolean isMatch(User user) {
                    return user.isActive() && super.isMatch(user);
                }

                @Override
                Query<User> getQuery(String username, int offset, int limit) {
                    return new UserMembersOfGroupQuery(User.class, true, EntityDescriptor.group(), EntityDescriptor.user(), offset, limit, (SearchRestriction)NullRestrictionImpl.INSTANCE, new String[]{groupName});
                }
            };
        }
        return filter.scan(pageRequest, username);
    }

    @Nonnull
    public Page<User> findUsersByName(String username, @Nonnull PageRequest pageRequest) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return this.findUsers(pageRequest);
        }
        Objects.requireNonNull(pageRequest, "pageRequest");
        return new UserMatchingFilter(this, this.crowdService, username){

            @Override
            Query<User> getQuery(String filter, int offset, int limit) {
                BooleanRestriction restriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{ACTIVE_USERS_ONLY, Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)filter), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)filter), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)filter)})});
                return new UserQuery(User.class, (SearchRestriction)restriction, offset, limit);
            }
        }.scan(pageRequest, username);
    }

    @Nonnull
    public Iterable<String> findUsernames(@Nonnull CrowdUserSearchRequest searchRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest");
        UserQuery query = new UserQuery(String.class, this.getUserSearchRestrictions(searchRequest), 0, -1);
        try (Timer ignored = TimerUtils.start((String)"Searching for usernames by property");){
            Iterable iterable = searchRequest.getDirectoryId().map(directoryId -> {
                try {
                    return this.directoryManager.searchUsers(directoryId.longValue(), (EntityQuery)query);
                }
                catch (DirectoryNotFoundException | OperationFailedException e) {
                    log.error("Could not search for users in directory with ID {}", directoryId, (Object)e);
                    throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.user.search.failed", new Object[]{e}));
                }
            }).orElseGet(() -> this.crowdService.search((Query)query));
            return iterable;
        }
    }

    @Nonnull
    public Page<String> findUsernamesByGroups(@Nonnull Set<String> groupNames, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(groupNames, "groupNames");
        Objects.requireNonNull(pageRequest, "pageRequest");
        if (groupNames.isEmpty()) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        MembershipQuery query = new MembershipQuery(String.class, true, EntityDescriptor.group(), EntityDescriptor.user(), pageRequest.getStart(), pageRequest.getLimit() + 1, ACTIVE_USERS_ONLY, groupNames);
        return this.getQueryPage((Query)query, pageRequest);
    }

    @Nonnull
    public Iterable<com.atlassian.crowd.model.user.UserWithAttributes> findUsersWithAttributes(@Nonnull Collection<String> usernames) {
        Objects.requireNonNull(usernames, "usernames");
        if (usernames.isEmpty()) {
            return Collections.emptyList();
        }
        BooleanRestriction restriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{ACTIVE_USERS_ONLY, Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatchingAny(usernames)});
        UserQuery query = new UserQuery(com.atlassian.crowd.model.user.UserWithAttributes.class, (SearchRestriction)restriction, 0, -1);
        try (Timer ignored = TimerUtils.start((String)("Retrieving " + usernames.size() + " UserWithAttributes"));){
            List list = this.applicationService.searchUsers(this.applicationFactory.getApplication(), (EntityQuery)query);
            return list;
        }
    }

    public UserWithAttributes findUserWithAttributes(@Nonnull String username) {
        Objects.requireNonNull(username, "username");
        UserWithAttributes user = this.crowdService.getUserWithAttributes(username);
        return user != null && user.isActive() ? user : null;
    }

    @Nonnull
    public Group getGroup(@Nonnull String groupName) {
        Group group = this.findGroup(groupName);
        if (group == null) {
            throw new NoSuchGroupException(this.i18nService.createKeyedMessage("bitbucket.service.groups.noSuchGroup", new Object[]{groupName}), groupName);
        }
        return group;
    }

    @Nonnull
    public Iterable<String> getGroupsByUser(@Nonnull String username) {
        Objects.requireNonNull(username, "username");
        return this.crowdService.search((Query)new GroupMembershipQuery(String.class, false, EntityDescriptor.user(), EntityDescriptor.group(), 0, -1, (SearchRestriction)NullRestrictionImpl.INSTANCE, new String[]{username}));
    }

    @Nonnull
    public User getUser(@Nonnull String username) {
        User user = this.findUser(username, false);
        if (user == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.users.noSuchUser", new Object[]{username}), username);
        }
        return user;
    }

    @Nonnull
    public User getRemoteUser(long directoryId, @Nonnull String username) {
        try {
            return this.directoryManager.findRemoteUserByName(Long.valueOf(directoryId), username);
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.users.noSuchUser", new Object[]{username}), username);
        }
    }

    public boolean isGroupMember(@Nonnull String groupName, @Nonnull User user) {
        Objects.requireNonNull(groupName, "groupName");
        Objects.requireNonNull(user, "user");
        long directoryId = user.getDirectoryId();
        try {
            return this.directoryManager.isUserNestedGroupMember(directoryId, user.getName(), groupName);
        }
        catch (DirectoryNotFoundException e) {
            log.error(String.format("No directory exists with ID %1$d", directoryId), (Throwable)e);
        }
        catch (OperationFailedException e) {
            log.error(String.format("Could not determine group membership in %1$s for %2$s", groupName, user.getName()), (Throwable)e);
        }
        return false;
    }

    public boolean isGroupMemberOfGroup(@Nonnull String childGroupName, @Nonnull String parentGroupName) {
        Objects.requireNonNull(childGroupName, "childGroupName");
        Objects.requireNonNull(parentGroupName, "parentGroupName");
        return this.crowdService.isGroupMemberOfGroup(childGroupName, parentGroupName);
    }

    @Nonnull
    public List<Directory> listDirectories() {
        return this.directoryService.findAllDirectories();
    }

    public boolean removeGroupMember(@Nonnull Group group, @Nonnull User user) {
        Objects.requireNonNull(group, "group");
        Objects.requireNonNull(user, "user");
        return this.execute(crowdService -> {
            try {
                return crowdService.removeUserFromGroup(user, group);
            }
            catch (GroupNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to remove " + user.getName() + " from " + group.getName() + " because the group was not found", (Throwable)e);
                }
                return false;
            }
            catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to remove " + user.getName() + " from " + group.getName() + " because the user was not found", (Throwable)e);
                }
                return false;
            }
            catch (OperationNotPermittedException e) {
                log.warn("Could not remove " + user.getName() + " from " + group.getName(), (Throwable)e);
                throw new AuthenticationSystemException(this.i18nService.createKeyedMessage("bitbucket.service.removemember.notpermitted", new Object[]{user.getName(), group.getName()}));
            }
        });
    }

    public void removeUserAttribute(@Nonnull User user, @Nonnull String attributeName) {
        Objects.requireNonNull(attributeName, "attributeName");
        Objects.requireNonNull(user, "user");
        this.execute(crowdService -> crowdService.removeUserAttribute(user, attributeName));
    }

    public User renameUser(@Nonnull User user, @Nonnull String newUsername) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(newUsername, "newUserName");
        return this.execute(crowdService -> {
            try {
                return crowdService.renameUser(user, newUsername);
            }
            catch (InvalidUserException e) {
                throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.user.alreadyexists", new Object[]{newUsername}));
            }
            catch (UnsupportedOperationException e) {
                Directory directory = this.directoryManager.findDirectoryById(user.getDirectoryId());
                throw new ForbiddenException(this.i18nService.createKeyedMessage("bitbucket.service.user.rename.not.allowed", new Object[]{directory.getName()}));
            }
        });
    }

    @Nonnull
    <T> Iterable<T> search(@Nonnull Query<T> query) {
        return this.crowdService.search(Objects.requireNonNull(query, "query"));
    }

    public void setPassword(@Nonnull User user, @Nonnull String password) {
        Objects.requireNonNull(user, "user");
        Preconditions.checkArgument((!Objects.requireNonNull(password, "password").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank password is required");
        try {
            this.crowdService.updateUserCredential(user, password);
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            throw this.unknownUser(user.getName());
        }
        catch (CrowdException | CrowdRuntimeException e) {
            throw this.cannotUpdatePassword(user.getName(), (Exception)e);
        }
    }

    public void setUserAttribute(@Nonnull User user, @Nonnull String attributeName, @Nonnull Object attributeValue) {
        Objects.requireNonNull(attributeName, "attributeName");
        Objects.requireNonNull(attributeValue, "attributeValue");
        Objects.requireNonNull(user, "user");
        this.execute(crowdService -> {
            try {
                crowdService.setUserAttribute(user, attributeName, String.valueOf(attributeValue));
            }
            catch (OperationNotPermittedException e) {
                String message = String.format("Couldn't update the %1$s attribute for %2$s", attributeName, user.getName());
                if (log.isDebugEnabled()) {
                    log.debug(message, (Throwable)e);
                }
                log.error(message);
            }
        });
    }

    public User updatePassword(@Nonnull String username, @Nonnull String oldPassword, @Nonnull String newPassword) {
        try {
            User user = this.doAuthenticate(username, oldPassword);
            this.setPassword(user, newPassword);
            SpringTransactionUtils.invokeAfterCommit(() -> this.credentialCache.remove(RiotPolice.hashCredentials(username, oldPassword)));
            return user;
        }
        catch (IncorrectPasswordAuthenticationException e) {
            throw new IncorrectPasswordAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.service.user.password.invalid", new Object[0]));
        }
    }

    @Nonnull
    public User updateUser(@Nonnull User user) {
        Objects.requireNonNull(user, "user");
        try {
            return this.crowdService.updateUser(user);
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            throw this.unknownUser(user.getName());
        }
        catch (CrowdException | CrowdRuntimeException e) {
            throw this.cannotUpdateProfile(user, (Exception)e);
        }
    }

    @Nonnull
    public UserCapabilities getCapabilitiesForNewUsers() {
        return this.crowdService.getCapabilitiesForNewUsers();
    }

    private static String hashCredentials(String username, String password) {
        return DigestUtils.sha256Hex((String)(username + "\u0000" + password));
    }

    private KeyedMessage authenticationFailed() {
        return this.i18nService.createKeyedMessage("bitbucket.auth.failed", new Object[0]);
    }

    private ServerException cannotUpdateOtherProfile(String username, Exception e) {
        KeyedMessage keyedText = this.i18nService.createKeyedMessage("bitbucket.service.users.canNotUpdate", new Object[]{username});
        if (log.isDebugEnabled()) {
            log.debug("The user profile for " + username + " could not be updated", (Throwable)e);
        }
        throw new ServerException(keyedText, (Throwable)e);
    }

    private ServerException cannotUpdateOwnProfile(String name, Exception e) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.user.profile.cannotUpdate", new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug(name + " could not update their own profile", (Throwable)e);
        }
        throw new ServerException(message, (Throwable)e);
    }

    private ServerException cannotUpdatePassword(String username, Exception e) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.service.user.password.canNotUpdate", new Object[]{username});
        if (log.isDebugEnabled()) {
            log.debug("The password for " + username + " could not be updated", (Throwable)e);
        }
        throw new ServerException(message, (Throwable)e);
    }

    private ServerException cannotUpdateProfile(User user, Exception e) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser != null && StringUtils.equals((CharSequence)currentUser.getName(), (CharSequence)user.getName())) {
            throw this.cannotUpdateOwnProfile(user.getName(), e);
        }
        throw this.cannotUpdateOtherProfile(user.getName(), e);
    }

    private AuthenticationSystemException crowdFailed(Exception e) {
        if (log.isDebugEnabled()) {
            log.debug("A Crowd request failed with an unexpected exception type", (Throwable)e);
        }
        throw new AuthenticationSystemException(this.i18nService.createKeyedMessage("bitbucket.service.crowd.failed", new Object[0]), (Throwable)e);
    }

    private User doAuthenticate(String username, String password) {
        try {
            User user = this.crowdService.authenticate(username, password);
            if (user == null) {
                throw new NoSuchUserException(this.noAccountDetails(username), username);
            }
            return user;
        }
        catch (AccountNotFoundException e) {
            throw this.unknownUser(username);
        }
        catch (ExpiredCredentialException e) {
            throw new ExpiredPasswordAuthenticationException(this.expiredCredentials());
        }
        catch (InactiveAccountException e) {
            throw new InactiveUserAuthenticationException(this.inactiveAccount());
        }
        catch (FailedAuthenticationException e) {
            throw new IncorrectPasswordAuthenticationException(this.authenticationFailed());
        }
        catch (CrowdRuntimeException e) {
            throw new AuthenticationSystemException(this.i18nService.createKeyedMessage("bitbucket.service.crowd.authenticatefailed", new Object[0]), (Throwable)e);
        }
    }

    private <T> T execute(CrowdCallback<T> callback) {
        try {
            return callback.execute(this.crowdService);
        }
        catch (GroupNotFoundException e) {
            throw this.unknownGroup(e.getGroupName());
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            throw this.unknownUser(e.getUserName());
        }
        catch (CrowdRuntimeException e) {
            throw this.crowdFailed((Exception)((Object)e));
        }
        catch (com.atlassian.crowd.exception.GroupNotFoundException e) {
            throw this.unknownGroup(e.getGroupName());
        }
        catch (UserNotFoundException e) {
            throw this.unknownUser(e.getUserName());
        }
        catch (CrowdException e) {
            throw this.crowdFailed((Exception)((Object)e));
        }
    }

    private KeyedMessage expiredCredentials() {
        return this.i18nService.createKeyedMessage("bitbucket.service.user.expiredcredentials", new Object[0]);
    }

    private <T> Page<T> getQueryPage(Query<T> query, PageRequest pageRequest) {
        return PageUtils.createPage((Iterable)this.crowdService.search(query), (PageRequest)pageRequest);
    }

    private SearchRestriction getUserSearchRestrictions(CrowdUserSearchRequest searchRequest) {
        ArrayList<PropertyRestriction<Boolean>> restrictions = new ArrayList<PropertyRestriction<Boolean>>();
        restrictions.add(ACTIVE_USERS_ONLY);
        searchRequest.getUserFilterText().ifPresent(filterText -> restrictions.add((PropertyRestriction<Boolean>)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing(filterText), Restriction.on((Property)UserTermKeys.USERNAME).containing(filterText), Restriction.on((Property)UserTermKeys.EMAIL).containing(filterText)})));
        searchRequest.getLastActiveBefore().ifPresent(lastActiveBefore -> restrictions.add(Restriction.on((Property)new PropertyImpl("lastAuthenticationTimestamp", Long.class)).lessThan(lastActiveBefore)));
        searchRequest.getLastActiveAfter().ifPresent(lastActiveAfter -> restrictions.add(Restriction.on((Property)new PropertyImpl("lastAuthenticationTimestamp", Long.class)).greaterThan(lastActiveAfter)));
        return Combine.allOf(restrictions);
    }

    private KeyedMessage inactiveAccount() {
        return this.i18nService.createKeyedMessage("bitbucket.service.user.inactive", new Object[0]);
    }

    private KeyedMessage noAccountDetails(String username) {
        return this.i18nService.createKeyedMessage("bitbucket.service.user.nodetails", new Object[]{username});
    }

    private NoSuchGroupException unknownGroup(String groupName) {
        throw new NoSuchGroupException(this.i18nService.createKeyedMessage("bitbucket.service.group.unknown", new Object[]{groupName}), groupName);
    }

    private NoSuchUserException unknownUser(String username) {
        throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.user.unknown", new Object[]{username}), username);
    }

    @FunctionalInterface
    private static interface VoidCrowdCallback
    extends CrowdCallback<Void> {
        @Override
        default public Void execute(CrowdService crowdService) throws CrowdException {
            this.internalExecute(crowdService);
            return null;
        }

        public void internalExecute(CrowdService var1) throws CrowdException;
    }

    @FunctionalInterface
    private static interface CrowdCallback<T> {
        public T execute(CrowdService var1) throws CrowdException;
    }
}

