/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd.upgrade;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.crowd.CrowdEncryptionConfigurationException;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.upgrade.UpgradeTask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@UpgradeTask(value="core-encrypt-crowd-directory-passwords")
public class EncryptCrowdDirectoryPasswordsUpgradeTask {
    static final String KEY_TASK = "core-encrypt-crowd-directory-passwords";
    private static final Logger log = LoggerFactory.getLogger(EncryptCrowdDirectoryPasswordsUpgradeTask.class);
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final CrowdDirectoryService directoryService;
    private final boolean encryptionEnabled;
    private final LockService lockService;
    private final TransactionTemplate readWriteTransaction;

    public EncryptCrowdDirectoryPasswordsUpgradeTask(InternalApplicationPropertiesService applicationPropertiesService, CrowdDirectoryService directoryService, LockService lockService, PlatformTransactionManager transactionManager, boolean encryptionEnabled) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.directoryService = directoryService;
        this.lockService = lockService;
        this.readWriteTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)0));
        this.encryptionEnabled = encryptionEnabled;
    }

    public void apply() throws IOException {
        if (!this.encryptionEnabled) {
            log.debug("Directory password encryption disabled, skipping upgrade task.");
            return;
        }
        if (this.isMirrorMode()) {
            log.debug("Instance is a mirror, skipping upgrade task for encrypting user directory passwords.");
            return;
        }
        try {
            this.readWriteTransaction.execute(status -> {
                if (this.applicationPropertiesService.isCrowdEncryptionUpgradeCompleted()) {
                    log.debug("Skipping upgrade task as Crowd directory passwords have already been encrypted");
                    return null;
                }
                try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(KEY_TASK));){
                    log.debug("Locked upgrade task {}", (Object)KEY_TASK);
                    if (this.applicationPropertiesService.isCrowdEncryptionUpgradeCompleted()) {
                        log.debug("Skipping upgrade task as Crowd directory passwords have already been encrypted");
                        Object var3_3 = null;
                        return var3_3;
                    }
                    this.doUpgrade();
                    this.applicationPropertiesService.setCrowdEncryptionUpgradeCompleted();
                }
                log.info("User directory password encryption upgrade task completed.");
                return null;
            });
        }
        catch (RuntimeException e) {
            throw new CrowdEncryptionConfigurationException("Error running Crowd encryption upgrade task", (Throwable)e);
        }
    }

    private void doUpgrade() {
        List directories = this.directoryService.findAllDirectories();
        log.debug("Re-persisting directories. User directory count: [{}].", (Object)directories.size());
        for (Directory directory : directories) {
            this.directoryService.updateDirectory(directory);
        }
    }

    private boolean isMirrorMode() {
        return this.applicationPropertiesService.getMode() == ApplicationMode.MIRROR;
    }
}

