/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.dashboard;

import com.atlassian.bitbucket.dashboard.DashboardService;
import com.atlassian.bitbucket.dashboard.PullRequestSuggestion;
import com.atlassian.bitbucket.dashboard.SuggestPullRequestsRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.RepositoryInconsistentException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.SatiableConsumer;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.dashboard.RecentPush;
import com.atlassian.stash.internal.dashboard.SimplePullRequestSuggestion;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=DashboardService.class)
@Service(value="dashboardService")
public class DefaultDashboardService
extends AbstractService
implements DashboardService {
    private static final int LIMIT_MAX = 25;
    private static final String QUALIFIED_BRANCH_PREFIX = "refs/heads/";
    private static final int SUGGESTION_CANDIDATES_MAX = 200;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final RefService refService;
    private final RepositoryActivityDao repositoryActivityDao;
    @Value(value="${dashboard.pull-request-suggestions.timeout:10}")
    private long suggestionTimeoutSeconds;

    @Autowired
    public DefaultDashboardService(I18nService i18nService, PermissionService permissionService, RefService refService, RepositoryActivityDao repositoryActivityDao) {
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.refService = refService;
        this.repositoryActivityDao = repositoryActivityDao;
    }

    @PreAuthorize(value="isAuthenticated()")
    public Page<PullRequestSuggestion> suggestPullRequests(@Nonnull SuggestPullRequestsRequest request) {
        Objects.requireNonNull(request, "request");
        int limit = request.getLimit();
        if (limit < 1 || limit > 25) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.dashboard.limit.invalid", new Object[]{limit, 1, 25}));
        }
        SuggestionCandidateConsumer consumer = new SuggestionCandidateConsumer(limit);
        this.repositoryActivityDao.findRecentPushesForUser(request.getUser().getId(), request.getChangesSince(), (SatiableConsumer)consumer);
        return PageUtils.createPage(consumer.getResults(), (boolean)true, (PageRequest)PageUtils.newRequest((int)0, (int)limit));
    }

    private class SuggestionCandidateConsumer
    implements SatiableConsumer<RecentPush> {
        private static final int CACHE_SIZE = 20;
        private final Instant deadline;
        private final LoadingCache<Repository, Optional<Branch>> defaultBranchCache;
        private final Set<Pair<Integer, String>> dupeTestSet;
        private final LoadingCache<Integer, Boolean> repoPermissionCache;
        private final List<PullRequestSuggestion> results;
        private final int limit;
        private int candidates;

        private SuggestionCandidateConsumer(int limit) {
            this.limit = limit;
            this.deadline = Instant.now().plus(Duration.ofSeconds(DefaultDashboardService.this.suggestionTimeoutSeconds));
            this.dupeTestSet = new HashSet<Pair<Integer, String>>();
            this.results = new ArrayList<PullRequestSuggestion>();
            this.repoPermissionCache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<Integer, Boolean>(){

                public Boolean load(@Nonnull Integer key) {
                    return DefaultDashboardService.this.permissionService.hasRepositoryPermission(key.intValue(), Permission.REPO_WRITE);
                }
            });
            this.defaultBranchCache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<Repository, Optional<Branch>>(){

                public Optional<Branch> load(@Nonnull Repository key) {
                    try {
                        return Optional.of(DefaultDashboardService.this.refService.getDefaultBranch(key));
                    }
                    catch (RepositoryInconsistentException | NoDefaultBranchException | RepositoryOfflineException e) {
                        return Optional.empty();
                    }
                }
            });
        }

        public boolean accept(RecentPush value) {
            ++this.candidates;
            if (Instant.now().isAfter(this.deadline)) {
                return true;
            }
            if (value.getRefId().startsWith(DefaultDashboardService.QUALIFIED_BRANCH_PREFIX) && this.hasRepoWritePermission(value.getRepository())) {
                try {
                    ((Optional)this.defaultBranchCache.getUnchecked((Object)value.getRepository())).ifPresent(defaultBranch -> this.transformSuggestion(value, (Branch)defaultBranch).filter(this::isAvailable).filter(suggestion -> this.isValidForDefaultBranchRules((SimplePullRequestSuggestion)suggestion, (Branch)defaultBranch)).filter(this::isUnique).ifPresent(this.results::add));
                }
                catch (UncheckedExecutionException e) {
                    throw Throwables.propagate((Throwable)e.getCause());
                }
            }
            return this.results.size() >= this.limit || this.candidates >= 200;
        }

        private boolean isValidForDefaultBranchRules(SimplePullRequestSuggestion suggestion, Branch defaultBranch) {
            return !suggestion.getRefChange().getRef().getId().equals(defaultBranch.getId()) || suggestion.getRepository().isFork();
        }

        public List<PullRequestSuggestion> getResults() {
            return this.results;
        }

        private boolean hasRepoWritePermission(Repository repository) {
            return (Boolean)this.repoPermissionCache.getUnchecked((Object)repository.getId());
        }

        private boolean isAvailable(PullRequestSuggestion suggestion) {
            return suggestion.getRepository().getState() == Repository.State.AVAILABLE;
        }

        private boolean isUnique(PullRequestSuggestion suggestion) {
            return this.dupeTestSet.add((Pair<Integer, String>)new Pair((Object)suggestion.getRepository().getId(), (Object)suggestion.getRefChange().getRef().getId()));
        }

        private Optional<SimplePullRequestSuggestion> transformSuggestion(RecentPush recentPush, Branch defaultBranch) {
            Ref ref = DefaultDashboardService.this.refService.resolveRef(new ResolveRefRequest.Builder(recentPush.getRepository()).refId(recentPush.getRefId()).type((RefType)StandardRefType.BRANCH).build());
            if (ref == null) {
                return Optional.empty();
            }
            SimpleRefChange refChange = ((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().ref((MinimalRef)ref)).fromHash(recentPush.getFromHash())).toHash(recentPush.getToHash())).type(recentPush.getRefChangeType())).build();
            return Optional.of(new SimplePullRequestSuggestion(recentPush.getChangeDate(), (RefChange)refChange, recentPush.getRepository(), (MinimalRef)defaultBranch));
        }
    }
}

