/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.date;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.IllegalUserStateException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.date.DateType;
import com.atlassian.stash.internal.date.InternalDateTypePreferenceService;
import com.atlassian.stash.internal.date.UserDateTypeChangedEvent;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.InternalNormalUser;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class DefaultDateTypePreferenceService
implements InternalDateTypePreferenceService {
    private static final String DATE_PREFERENCE_KEY = "USER_DATE_PREFERENCE";
    private final InternalAuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final UserSettingsService userSettingsService;

    @Autowired
    public DefaultDateTypePreferenceService(EventPublisher eventPublisher, I18nService i18nService, InternalAuthenticationContext authenticationContext, UserSettingsService userSettingsService) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.userSettingsService = userSettingsService;
    }

    @Nonnull
    @Unsecured(value="Method handles input from unauthenticated users")
    public Optional<DateType> get() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getDateType(UserKey.fromLong((long)currentUser.getId())));
    }

    @PreAuthorize(value="hasUserPermission('USER_ADMIN')")
    public void set(@Nonnull DateType newDateType) {
        Objects.requireNonNull(newDateType, "newDataType");
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        InternalNormalUser.fromUser((ApplicationUser)currentUser).orElseThrow(() -> new IllegalUserStateException(this.i18nService.createKeyedMessage("bitbucket.service.timestamp.user.cannot.set", new Object[]{InternalNormalUser.class, currentUser.getClass()})));
        UserKey userKey = UserKey.fromLong((long)currentUser.getId());
        DateType oldDateType = this.getDateType(userKey);
        if (oldDateType != newDateType) {
            this.userSettingsService.updateUserSettings(userKey, settings -> settings.put(DATE_PREFERENCE_KEY, newDateType.getId()).build());
            this.eventPublisher.publish((Object)new UserDateTypeChangedEvent(this, newDateType, oldDateType, currentUser));
        }
    }

    private DateType getDateType(UserKey userKey) {
        return this.userSettingsService.getUserSettings(userKey).getLong(DATE_PREFERENCE_KEY).toOptional().flatMap(DateType::fromId).orElse(null);
    }
}

