/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.date;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.date.DateType;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@EventName(value="stash.user.date.format.changed")
public class UserDateTypeChangedEvent
extends ApplicationEvent {
    private final DateType newDateType;
    private final DateType oldDateType;
    private final ApplicationUser updatedUser;

    public UserDateTypeChangedEvent(@Nonnull Object source, @Nonnull DateType newDateType, DateType oldDateType, @Nonnull ApplicationUser updatedUser) {
        super(source);
        this.newDateType = Objects.requireNonNull(newDateType, "newDateType");
        this.oldDateType = oldDateType;
        this.updatedUser = Objects.requireNonNull(updatedUser, "updatedUser");
    }

    @Nonnull
    public DateType getNewDateType() {
        return this.newDateType;
    }

    public DateType getOldDateType() {
        return this.oldDateType;
    }

    @Nonnull
    public ApplicationUser getUpdatedUser() {
        return this.updatedUser;
    }
}

