/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Drainable;
import com.atlassian.bitbucket.util.ForcedDrainable;
import com.atlassian.bitbucket.util.ProxyUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.nutcluster.core.Cluster;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDao;
import com.atlassian.stash.internal.db.DatabaseHandle;
import com.atlassian.stash.internal.db.DatabaseLatch;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.db.DatabaseValidationException;
import com.atlassian.stash.internal.db.DatabaseValidator;
import com.atlassian.stash.internal.db.DefaultDatabaseHandle;
import com.atlassian.stash.internal.hibernate.SwappableSessionFactory;
import com.atlassian.stash.internal.jdbc.CloseableDataSource;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.DataSourceFactory;
import com.atlassian.stash.internal.jdbc.MutableDataSourceConfiguration;
import com.atlassian.stash.internal.jdbc.SwappableDataSource;
import com.atlassian.stash.internal.maintenance.latch.ClusterableLatch;
import com.atlassian.stash.internal.maintenance.latch.LatchMode;
import com.atlassian.stash.internal.maintenance.latch.LatchState;
import com.atlassian.stash.internal.migration.DatabaseMigrationException;
import com.atlassian.stash.internal.migration.DatabaseMigrationValidationException;
import com.atlassian.stash.internal.util.TransactionAwareLatchedInvocationHandler;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.InfrastructureProxy;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component(value="databaseManager")
public class DefaultDatabaseManager
implements DatabaseManager,
BeanNameAware,
Ordered {
    static final String PROTOTYPE_SESSION_FACTORY = "sessionFactoryPrototype";
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseManager.class);
    private final ApplicationContext applicationContext;
    private final Cluster cluster;
    private final DatabaseValidator databaseValidator;
    private final MutableDataSourceConfiguration dataSourceConfiguration;
    private final DataSourceFactory dataSourceFactory;
    private final IExecutorService executorService;
    private final I18nService i18nService;
    private final LiquibaseDao liquibaseDao;
    private final Object lock;
    private final SwappableDataSource swappableDataSource;
    private final SwappableSessionFactory swappableSessionFactory;
    private String beanName;
    private DataSource realDataSource;
    private SessionFactoryImplementor realSessionFactory;
    private DataSourceConfiguration realDataSourceConfiguration;
    private volatile DelegatingDatabaseLatch latch;

    @Autowired
    public DefaultDatabaseManager(ApplicationContext applicationContext, Cluster cluster, DatabaseValidator databaseValidator, MutableDataSourceConfiguration dataSourceConfiguration, DataSourceFactory dataSourceFactory, IExecutorService executorService, I18nService i18nService, LiquibaseDao liquibaseDao, SwappableDataSource swappableDataSource, SwappableSessionFactory swappableSessionFactory) {
        this.applicationContext = applicationContext;
        this.cluster = cluster;
        this.databaseValidator = databaseValidator;
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.dataSourceFactory = dataSourceFactory;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.liquibaseDao = liquibaseDao;
        this.swappableDataSource = swappableDataSource;
        this.swappableSessionFactory = swappableSessionFactory;
        this.lock = new Object();
    }

    @Nonnull
    public DatabaseLatch acquireLatch(@Nonnull LatchMode latchMode) {
        return this.acquireLatch(latchMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public DatabaseLatch acquireLatch(@Nonnull LatchMode latchMode, String latchId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isLatched()) {
                throw new IllegalStateException("The database has already been latched");
            }
            try {
                this.latch = new DelegatingDatabaseLatch(latchMode, new CountDownLatch(1));
                this.latch.acquire(latchId);
            }
            finally {
                if (!this.latch.isAcquired()) {
                    this.latch = null;
                }
            }
            return this.latch;
        }
    }

    public DatabaseLatch getCurrentLatch() {
        return this.isLatched() ? this.latch : null;
    }

    @Nonnull
    public DatabaseHandle getHandle() {
        return new DefaultDatabaseHandle(this.dataSourceConfiguration.copy(), this.swappableDataSource.getWrappedObject(), this.swappableSessionFactory.getWrappedObject());
    }

    public int getOrder() {
        return 0;
    }

    @Nonnull
    public LatchState getState() {
        DatabaseLatch dbLatch = this.getCurrentLatch();
        if (dbLatch == null) {
            return LatchState.AVAILABLE;
        }
        if (dbLatch.drain(0L, TimeUnit.NANOSECONDS)) {
            return LatchState.DRAINED;
        }
        return LatchState.LATCHED;
    }

    public boolean isLatched() {
        DelegatingDatabaseLatch current = this.latch;
        return current != null && current.isAcquired();
    }

    @EventListener
    public void onNodeAdded(ClusterNodeAddedEvent event) {
        DelegatingDatabaseLatch current = this.latch;
        if (current != null) {
            current.onNodeJoined(event.getAddedNode());
        }
    }

    @Nonnull
    public DatabaseHandle prepareDatabase(@Nonnull DataSourceConfiguration targetConfiguration) {
        log.debug("Validating the configuration of the DataSource for the new database");
        this.validateConfiguration(targetConfiguration);
        log.debug("Creating a DataSource connected to the target database");
        DataSource newDataSource = this.createDataSource(targetConfiguration);
        log.debug("Creating the {} schema in the target database", (Object)Product.NAME);
        this.createSchema(newDataSource);
        log.debug("Creating Hibernate SessionFactory on the target database and validating the schema");
        SessionFactoryImplementor newSessionFactory = this.createSessionFactory(newDataSource, targetConfiguration);
        log.debug("The new database has been prepared.");
        return new DefaultDatabaseHandle(targetConfiguration, newDataSource, newSessionFactory);
    }

    public void setBeanName(@Nonnull String name) {
        this.beanName = name;
    }

    public void validateConfiguration(@Nonnull DataSourceConfiguration configuration) {
        Objects.requireNonNull(configuration, "configuration");
        log.debug("Creating a DataSource to test the provided configuration");
        try (CloseableDataSource dataSource = this.dataSourceFactory.createForValidation(configuration);){
            log.debug("Validating connection and target database for: {}", (Object)configuration.getUrl());
            this.databaseValidator.validate((DataSource)dataSource);
        }
        catch (CannotGetJdbcConnectionException e) {
            log.warn("A connection could not be opened with the DataSource", (Throwable)e);
            throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.test.connectfailed", new Object[0]), (Throwable)e);
        }
        catch (DataRetrievalFailureException e) {
            log.warn("Support for the target database could not be verified", (Throwable)e);
            throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.test.supportunverified", new Object[]{Product.NAME}), (Throwable)e);
        }
        catch (DataAccessException e) {
            log.warn("An unexpected exception prevented validating the target database", (Throwable)e);
            throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.test.unexpectedfailure", new Object[]{Product.NAME}), (Throwable)e);
        }
        catch (DatabaseValidationException e) {
            throw new DatabaseMigrationValidationException(e.getKeyedMessage());
        }
    }

    void closeDataSource(@Nonnull DataSource dataSource) {
        Objects.requireNonNull(dataSource, "dataSource");
        log.debug("Closing DataSource to release database connections");
        if (dataSource instanceof Closeable) {
            try {
                ((Closeable)((Object)dataSource)).close();
            }
            catch (IOException | RuntimeException e) {
                log.warn("DataSource raised an exception while being closed.", (Throwable)e);
            }
        } else {
            Class<?> dataSourceClass = dataSource.getClass();
            log.debug("DataSource class [{}] does not implement Closeable", dataSourceClass);
            Method close = ReflectionUtils.findMethod(dataSourceClass, (String)"close");
            if (close == null) {
                log.warn("DataSource class [{}] does not have a close() method and will not be closed.", dataSourceClass);
            } else {
                log.debug("Invoking {}.{}() to close the DataSource", close.getDeclaringClass(), (Object)close.getName());
                try {
                    ReflectionUtils.invokeMethod((Method)close, (Object)dataSource);
                }
                catch (Exception e) {
                    log.warn(String.valueOf(dataSourceClass) + "." + close.getName() + "() did not run cleanly. The DataSource may not have been closed", (Throwable)e);
                }
            }
        }
    }

    @Nonnull
    DataSource createDataSource(@Nonnull DataSourceConfiguration configuration) {
        Objects.requireNonNull(configuration, "configuration");
        try {
            return this.dataSourceFactory.create(configuration);
        }
        catch (Exception e) {
            log.error("Failed to obtain data source", (Throwable)e);
            throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.create.datasource.failed", new Object[0]), Throwables.getRootCause((Throwable)e));
        }
    }

    void createSchema(@Nonnull DataSource dataSource) {
        Objects.requireNonNull(dataSource, "dataSource");
        try {
            this.liquibaseDao.createSchema(dataSource);
        }
        catch (Exception e) {
            log.error("Failed to create schema in target database.", (Throwable)e);
            throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.create.schema.failed", new Object[0]), (Throwable)e);
        }
    }

    @Nonnull
    SessionFactoryImplementor createSessionFactory(@Nonnull DataSource dataSource, @Nonnull DataSourceConfiguration targetConfiguration) {
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(targetConfiguration, "targetConfiguration");
        try {
            return (SessionFactoryImplementor)this.applicationContext.getBean(PROTOTYPE_SESSION_FACTORY, new Object[]{dataSource, targetConfiguration});
        }
        catch (Exception e) {
            log.error("Failed to obtain session factory", (Throwable)e);
            throw new DatabaseMigrationException(this.i18nService.createKeyedMessage("bitbucket.migration.create.sessionfactory.failed", new Object[0]), Throwables.getRootCause((Throwable)e));
        }
    }

    private InvocationHandler createLatchingInvocationHandler(InfrastructureProxy swappable, CountDownLatch countDownLatch) {
        return new TransactionAwareLatchedInvocationHandler(swappable, countDownLatch, swappable.getWrappedObject());
    }

    private class DelegatingDatabaseLatch
    extends ClusterableLatch
    implements DatabaseLatch {
        private final CountDownLatch latch;
        private volatile boolean drained;

        DelegatingDatabaseLatch(LatchMode mode, CountDownLatch latch) {
            super(mode, DefaultDatabaseManager.this.cluster, DefaultDatabaseManager.this.executorService, DefaultDatabaseManager.this.beanName);
            this.latch = latch;
        }

        @Override
        protected void acquireLocally() {
            DefaultDatabaseManager.this.realDataSourceConfiguration = DefaultDatabaseManager.this.dataSourceConfiguration.copy();
            DefaultDatabaseManager.this.realDataSource = DefaultDatabaseManager.this.swappableDataSource.swap((DataSource)ProxyUtils.createProxy(DataSource.class, (InvocationHandler)DefaultDatabaseManager.this.createLatchingInvocationHandler((InfrastructureProxy)DefaultDatabaseManager.this.swappableDataSource, this.latch), (Class[])new Class[]{InfrastructureProxy.class}));
            DefaultDatabaseManager.this.realSessionFactory = DefaultDatabaseManager.this.swappableSessionFactory.swap((SessionFactoryImplementor)ProxyUtils.createProxy(SessionFactoryImplementor.class, (InvocationHandler)DefaultDatabaseManager.this.createLatchingInvocationHandler((InfrastructureProxy)DefaultDatabaseManager.this.swappableSessionFactory, this.latch), (Class[])new Class[]{InfrastructureProxy.class}));
        }

        @Override
        protected boolean drainLocally(long timeout, @Nonnull TimeUnit unit, boolean force) {
            DataSource target;
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be non-negative");
            Objects.requireNonNull(unit, "unit");
            this.ensureInitiator();
            if (this.drained) {
                return true;
            }
            DataSource dataSource = target = DefaultDatabaseManager.this.realDataSource instanceof DelegatingDataSource ? ((DelegatingDataSource)DefaultDatabaseManager.this.realDataSource).getTargetDataSource() : DefaultDatabaseManager.this.realDataSource;
            if (target instanceof Drainable) {
                boolean didDrain;
                boolean bl = didDrain = force && target instanceof ForcedDrainable ? ((ForcedDrainable)target).forceDrain(timeout, unit) : ((Drainable)target).drain(timeout, unit);
                if (!didDrain) {
                    log.debug("The DataSource could not be drained; some database connections are still open.");
                    return false;
                }
                log.debug("The DataSource has been drained");
            } else {
                log.warn("The DataSource for the current database does not implement Drainable. Existing connections will not be closed.");
            }
            this.drained = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void unlatchLocally() {
            this.ensureInitiator();
            Object object = this.lock;
            synchronized (object) {
                DefaultDatabaseManager.this.dataSourceConfiguration.update(DefaultDatabaseManager.this.realDataSourceConfiguration);
                DefaultDatabaseManager.this.swappableDataSource.swap(DefaultDatabaseManager.this.realDataSource);
                DefaultDatabaseManager.this.swappableSessionFactory.swap(DefaultDatabaseManager.this.realSessionFactory);
                DefaultDatabaseManager.this.latch = null;
            }
            this.latch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlatchTo(@Nonnull DatabaseHandle databaseHandle) {
            this.ensureInitiator();
            Object object = this.lock;
            synchronized (object) {
                DefaultDatabaseManager.this.realDataSource = Objects.requireNonNull(databaseHandle.getDataSource(), "newDataSource");
                DefaultDatabaseManager.this.realDataSourceConfiguration = Objects.requireNonNull(databaseHandle.getConfiguration(), "newConfiguration");
                DefaultDatabaseManager.this.realSessionFactory = Objects.requireNonNull(databaseHandle.getSessionFactory(), "newSessionFactory");
                this.unlatch();
            }
        }

        private void ensureInitiator() {
            if (DefaultDatabaseManager.this.latch != this) {
                throw new IllegalStateException("This latch is no longer active");
            }
        }
    }
}

