/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.discovery;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.discovery.DiscoverableFeature;
import com.atlassian.bitbucket.dmz.discovery.FeatureDiscoveryService;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.user.InternalUserSettingsService;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={FeatureDiscoveryService.class})
@Service(value="featureDiscoveryService")
public class DefaultFeatureDiscoveryService
extends AbstractService
implements FeatureDiscoveryService {
    private static final String DISCOVERED_ALL_SESSION_KEY = "feature.discovery.all-discovered";
    private final AuthenticationContext authenticationContext;
    private final RequestManager requestManager;
    private final InternalUserSettingsService userSettingsService;

    @Autowired
    public DefaultFeatureDiscoveryService(AuthenticationContext authenticationContext, RequestManager requestManager, InternalUserSettingsService userSettingsService) {
        this.authenticationContext = authenticationContext;
        this.requestManager = requestManager;
        this.userSettingsService = userSettingsService;
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Set<DiscoverableFeature> getUndiscovered() {
        return this.getIfUndiscovered(EnumSet.allOf(DiscoverableFeature.class));
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    public Set<DiscoverableFeature> getIfUndiscovered(@Nonnull Set<DiscoverableFeature> features) {
        Objects.requireNonNull(features, "features");
        HttpSession session = this.getHttpSession();
        if (session != null && session.getAttribute(DISCOVERED_ALL_SESSION_KEY) == Boolean.TRUE) {
            return EnumSet.noneOf(DiscoverableFeature.class);
        }
        UserSettings userSettings = this.userSettingsService.getUserSettings(this.authenticationContext.getCurrentUser());
        Set undiscovered = (Set)EnumSet.allOf(DiscoverableFeature.class).stream().filter(feature -> !this.hasDiscovered(userSettings, (DiscoverableFeature)feature)).collect(MoreCollectors.toImmutableSet());
        if (undiscovered.isEmpty() && session != null) {
            session.setAttribute(DISCOVERED_ALL_SESSION_KEY, (Object)Boolean.TRUE);
        }
        return Sets.intersection(features, (Set)undiscovered);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public void setDiscovered(@Nonnull Set<DiscoverableFeature> features) {
        Objects.requireNonNull(features, "features");
        if (!features.isEmpty()) {
            this.userSettingsService.updateUserSettings(this.authenticationContext.getCurrentUser(), builder -> {
                features.forEach(feature -> builder.put(feature.getKey(), true));
                return builder.build();
            });
        }
    }

    private HttpSession getHttpSession() {
        RequestContext requestContext = this.requestManager.getRequestContext();
        if (requestContext == null) {
            return null;
        }
        Object rawRequest = requestContext.getRawRequest();
        return rawRequest instanceof HttpServletRequest ? ((HttpServletRequest)rawRequest).getSession(true) : null;
    }

    private boolean hasDiscovered(@Nonnull UserSettings userSettings, @Nonnull DiscoverableFeature feature) {
        return (Boolean)userSettings.getBoolean(feature.getKey()).orElse(() -> feature.getLegacyKey().map(arg_0 -> ((UserSettings)userSettings).getBoolean(arg_0)).orElse(Option.none())).orElse(() -> userSettings.getString("user.created.version").map(Version::new).map(version -> version.compareTo(feature.getVersion()) >= 0)).getOrElse((Object)Boolean.FALSE);
    }
}

