/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.emoticon;

import com.atlassian.bitbucket.dmz.emoticon.DmzEmoticon;
import com.atlassian.bitbucket.dmz.emoticon.DmzEmoticonService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.emoticon.EmoticonDao;
import com.atlassian.stash.internal.emoticon.InternalEmoticon;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=DmzEmoticonService.class)
@Service
public class DefaultEmoticonService
extends AbstractService
implements DmzEmoticonService {
    private final EmoticonDao dao;
    private final TransactionTemplate transactionTemplate;

    public DefaultEmoticonService(@Nonnull EmoticonDao dao, @Nonnull TransactionTemplate transactionTemplate) {
        this.dao = dao;
        this.transactionTemplate = transactionTemplate;
    }

    @Unsecured(value="Internal service method; no permission check necessary")
    public int delete(@Nonnull String provider) {
        Objects.requireNonNull(provider, "provider");
        int count = 0;
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)100);
        boolean hasMore = true;
        while (hasMore) {
            Page page = this.dao.findByProvider(provider, pageRequest);
            if (page.getSize() > 0) {
                this.transactionTemplate.execute(() -> {
                    this.dao.deleteBatch(page.getValues());
                    return null;
                });
                count += page.getSize();
                continue;
            }
            hasMore = false;
        }
        return count;
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    public Page<DmzEmoticon> find(@Nonnull String pattern, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pattern, "pattern");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return PageUtils.asPageOf(DmzEmoticon.class, (Page)this.dao.find(pattern, pageRequest));
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    public Page<DmzEmoticon> findAll(@Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        return PageUtils.asPageOf(DmzEmoticon.class, (Page)this.dao.findAll(pageRequest));
    }

    @Unsecured(value="Internal service method; no permission check necessary")
    public DmzEmoticon get(@Nonnull String shortcut) {
        Objects.requireNonNull(shortcut, "shortcut");
        return (DmzEmoticon)this.dao.getById((Object)shortcut);
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    public List<DmzEmoticon> get(@Nonnull Collection<String> shortcuts) {
        Objects.requireNonNull(shortcuts, "shortcuts");
        return ImmutableList.copyOf((Collection)this.dao.getByIds(shortcuts));
    }

    @Transactional
    @Unsecured(value="Internal service method; no permission check necessary")
    public void save(@Nonnull Iterable<DmzEmoticon> emoticons) {
        Objects.requireNonNull(emoticons, "emoticons");
        MoreStreams.streamIterable(emoticons).map(DefaultEmoticonService::convertToInternal).forEach(arg_0 -> ((EmoticonDao)this.dao).update(arg_0));
    }

    private static InternalEmoticon convertToInternal(DmzEmoticon emoticon) {
        return new InternalEmoticon.Builder(emoticon.getId(), emoticon.getProvider()).url(emoticon.getUrl()).value(emoticon.getValue()).build();
    }
}

