/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryPushEvent;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

@AsynchronousPreferred
@EventName(value="stash.repository.pushed")
public class AnalyticsRepositoryPushEvent
extends RepositoryPushEvent {
    private final boolean isFork;
    private final String protocol;
    private int branchesCreated;
    private int branchesDeleted;
    private int tagsCreated;
    private int tagsDeleted;

    public AnalyticsRepositoryPushEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Collection<RefChange> refChanges, @Nullable RequestMetadata requestMetadata) {
        super(source, repository, refChanges);
        this.isFork = repository.isFork();
        this.protocol = requestMetadata == null ? "other" : AnalyticsRepositoryPushEvent.getProtocol(requestMetadata);
        for (RefChange refChange : refChanges) {
            RefType refType = refChange.getRef().getType();
            RefChangeType refChangeType = refChange.getType();
            if (refType == StandardRefType.BRANCH) {
                if (refChangeType == RefChangeType.ADD) {
                    ++this.branchesCreated;
                    continue;
                }
                if (refChangeType != RefChangeType.DELETE) continue;
                ++this.branchesDeleted;
                continue;
            }
            if (refType != StandardRefType.TAG) continue;
            if (refChangeType == RefChangeType.ADD) {
                ++this.tagsCreated;
                continue;
            }
            if (refChangeType != RefChangeType.DELETE) continue;
            ++this.tagsDeleted;
        }
    }

    public long getBranchesCreated() {
        return this.branchesCreated;
    }

    public long getBranchesDeleted() {
        return this.branchesDeleted;
    }

    @Nonnull
    public String getProtocol() {
        return this.protocol;
    }

    public long getTagsCreated() {
        return this.tagsCreated;
    }

    public long getTagsDeleted() {
        return this.tagsDeleted;
    }

    public boolean isFork() {
        return this.isFork;
    }

    private static String getProtocol(RequestMetadata requestMetadata) {
        String protocol = requestMetadata.getProtocol();
        if (StringUtils.startsWithIgnoreCase((CharSequence)protocol, (CharSequence)"http")) {
            return "http";
        }
        return "ssh".equalsIgnoreCase(protocol) ? "ssh" : "other";
    }
}

