/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.bitbucket.dmz.mirror.SynchronizationState;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappedEvent;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappingEvent;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorSynchronizedEvent;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorStateEventPublisher {
    private final EventPublisher eventPublisher;

    @Autowired
    public MirrorStateEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void publish(@Nonnull SynchronizationState synchronizationState) {
        switch (Objects.requireNonNull(synchronizationState, "synchronizationState")) {
            case BOOTSTRAPPING: {
                this.eventPublisher.publish((Object)new MirrorBootstrappingEvent((Object)this));
                break;
            }
            case BOOTSTRAPPED: {
                this.eventPublisher.publish((Object)new MirrorBootstrappedEvent((Object)this));
                break;
            }
            case SYNCHRONIZED: {
                this.eventPublisher.publish((Object)new MirrorSynchronizedEvent((Object)this));
            }
        }
    }
}

