/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.filestore;

import com.atlassian.bitbucket.dmz.filestore.FileStoreService;
import com.atlassian.bitbucket.filestore.DeleteFilesRequest;
import com.atlassian.bitbucket.filestore.DeleteRecursiveRequest;
import com.atlassian.bitbucket.filestore.FileExistsRequest;
import com.atlassian.bitbucket.filestore.FileStoreConfigurationException;
import com.atlassian.bitbucket.filestore.FileStoreException;
import com.atlassian.bitbucket.filestore.GenerateGetUrlRequest;
import com.atlassian.bitbucket.filestore.GenerateGetUrlResponse;
import com.atlassian.bitbucket.filestore.GeneratePutUrlRequest;
import com.atlassian.bitbucket.filestore.GeneratePutUrlResponse;
import com.atlassian.bitbucket.filestore.PluginFileStore;
import com.atlassian.bitbucket.filestore.PluginFileStoreModuleDescriptor;
import com.atlassian.bitbucket.filestore.ReadFileRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=FileStoreService.class)
@Service
public class DefaultFileStoreService
extends AbstractService
implements FileStoreService {
    private static final Logger log = LoggerFactory.getLogger(DefaultFileStoreService.class);
    private static final String PROP_FILESTORE = "${bitbucket.filestore}";
    private final String configuredStore;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;
    private final ApplicationPropertiesService propertiesService;
    private volatile PluginFileStore delegate;

    @Autowired
    public DefaultFileStoreService(I18nService i18nService, PluginAccessor pluginAccessor, ApplicationPropertiesService propertiesService, @Value(value="${bitbucket.filestore}") String configuredStore) {
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
        this.propertiesService = propertiesService;
        this.configuredStore = configuredStore;
    }

    @Unsecured(value="Internal service method; no permission check necessary")
    public long deleteFiles(@Nonnull DeleteFilesRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateNamespace(request.getNamespace());
        return this.filestoreOrThrow().deleteFiles(request);
    }

    @Unsecured(value="Internal service method; no permission check necessary")
    public long deleteRecursive(@Nonnull DeleteRecursiveRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateNamespace(request.getNamespace());
        return this.filestoreOrThrow().deleteRecursive(request);
    }

    @Unsecured(value="Internal service method; no permission check necessary")
    public boolean fileExists(@Nonnull FileExistsRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateNamespace(request.getNamespace());
        return this.filestoreOrThrow().fileExists(request);
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    public GenerateGetUrlResponse generateGetUrl(@Nonnull GenerateGetUrlRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateNamespace(request.getNamespace());
        Preconditions.checkArgument((request.getPath() != null ? 1 : 0) != 0, (Object)"path is required");
        return this.filestoreOrThrow().generateGetUrl(request);
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    public GeneratePutUrlResponse generatePutUrl(@Nonnull GeneratePutUrlRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateNamespace(request.getNamespace());
        Preconditions.checkArgument((request.getPath() != null ? 1 : 0) != 0, (Object)"path is required");
        return this.filestoreOrThrow().generatePutUrl(request);
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    public String getConfiguredStore() {
        return StringUtils.isBlank((CharSequence)this.configuredStore) ? "default" : this.configuredStore;
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    public Optional<Long> getFreeSpace() {
        PluginFileStore fileStore = this.filestoreOrThrow();
        if (fileStore != null) {
            return fileStore.getFreeSpace();
        }
        return Optional.empty();
    }

    @Unsecured(value="Internal service method; no permission check necessary")
    public boolean isDefaultStore() {
        return StringUtils.isBlank((CharSequence)this.configuredStore);
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    public InputStream readFile(@Nonnull ReadFileRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateNamespace(request.getNamespace());
        Preconditions.checkArgument((request.getPath() != null ? 1 : 0) != 0, (Object)"path is required");
        return this.filestoreOrThrow().readFile(request);
    }

    @VisibleForTesting
    PluginFileStore createInstance() {
        if (this.propertiesService.getMode().equals((Object)ApplicationMode.MIRROR)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.configuredStore)) {
            return null;
        }
        Optional<PluginFileStore> fileStore = this.pluginAccessor.getEnabledModuleDescriptorsByClass(PluginFileStoreModuleDescriptor.class).stream().filter(descriptor -> descriptor.getKey().equalsIgnoreCase(this.configuredStore)).map(PluginFileStoreModuleDescriptor::getModule).findFirst();
        if (fileStore.isPresent()) {
            log.info("Configured pluggable file store: '{}'", (Object)this.configuredStore);
            return fileStore.get();
        }
        throw new FileStoreConfigurationException("Pluggable file store '" + this.configuredStore + "' not found");
    }

    @VisibleForTesting
    void validateNamespace(String namespace) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)namespace), (Object)"namespace is required");
        for (char c : namespace.toCharArray()) {
            if (this.isValidNamespaceCharacter(c)) continue;
            throw new IllegalArgumentException("Invalid character in namespace: " + c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginFileStore filestoreOrThrow() {
        if (this.delegate != null) {
            return this.delegate;
        }
        DefaultFileStoreService defaultFileStoreService = this;
        synchronized (defaultFileStoreService) {
            if (this.delegate == null) {
                try {
                    this.delegate = this.createInstance();
                }
                catch (Exception e) {
                    log.error("Error creating file store", (Throwable)e);
                    throw new FileStoreException(this.i18nService.createKeyedMessage("bitbucket.filestore.notconfigured", new Object[0]));
                }
            }
            return this.delegate;
        }
    }

    private boolean isValidNamespaceCharacter(char c) {
        return Character.isLetterOrDigit(c) || c == '-' || c == '_';
    }
}

