/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.filestore;

import com.atlassian.bitbucket.dmz.filestore.FileStoreService;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="fileStoreSupportData")
public class FileStoreSupportData
extends RootLevelSupportDataAppender {
    private static final String FILESTORE_CATEGORY = "bitbucket.atst.filestore";
    private static final String CONFIGURED_STORE = "bitbucket.atst.filestore.configured-store";
    private static final String FREE_SPACE = "bitbucket.atst.filestore.free-space";
    private final FileStoreService fileStoreService;

    @Autowired
    public FileStoreSupportData(FileStoreService fileStoreService) {
        this.fileStoreService = fileStoreService;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        String freeSpace = this.fileStoreService.getFreeSpace().map(Object::toString).orElse("unknown");
        supportDataBuilder.addCategory(FILESTORE_CATEGORY).addValue(CONFIGURED_STORE, this.fileStoreService.getConfiguredStore()).addValue(FREE_SPACE, freeSpace);
    }
}

